from ecs import TaskServiceHelper

task_service_helper = TaskServiceHelper(deployed)

task_statuses = task_service_helper.get_task_statuses()
tasks_failed_to_start = task_service_helper.filter_tasks_failed_to_start(task_statuses)
tasks_pending = task_service_helper.filter_tasks_pending(task_statuses)


if tasks_pending and not tasks_failed_to_start:
    retry_count = task_service_helper.get_current_retry_count(context, deployed.name)
    if retry_count > deployed.maxTaskWaitRetryCount:
        raise RuntimeError("Reached the maximum limit of {0} retries and some tasks {1} are still pending"
                           .format(retry_count - 1, tasks_pending))
    else:
        print "Waiting for tasks {0} to be running. Done with retry {1}".format(tasks_pending, retry_count)
        result = "RETRY"
        task_service_helper.increment_retry_counter(context, deployed.name)
else:
    if tasks_failed_to_start:
        raise RuntimeError("Some tasks {0} failed to start".format(tasks_failed_to_start))
    else:
        print "All tasks started."
