from cloudformation.utils.ci_factory import CIFactory
from cloudformation.utils.cf_client import CFClient

def process(task_vars):
    deployed = task_vars['previousDeployed']

    client = CFClient.new_instance(deployed.container)
    template_body = client.get_template_body(deployed)
    if template_body and 'Metadata' in template_body:
        template_metadata = template_body['Metadata']

        ci_fact = CIFactory.new_instance(repositoryService, metadataService, deployed.outputVariables)
        if template_metadata:
        # process individually to guarantee order
            if 'XLD::Environments' in template_metadata:
                ci_tmpl = template_metadata['XLD::Environments']
                ci_fact.deleteCis('Environments', ci_tmpl)

            if 'XLD::Infrastructure' in template_metadata:
                ci_tmpl = template_metadata['XLD::Infrastructure']
                ci_fact.deleteCis('Infrastructure', ci_tmpl)

            if 'XLD::Applications' in template_metadata:
                ci_tmpl = template_metadata['XLD::Applications']
                ci_fact.deleteCis('Applications', ci_tmpl)

    print "Done"


if __name__ == '__main__' or __name__ == '__builtin__':
    process(locals())
