from cloudformation.utils.cf_client import CFClient


def process(task_vars):
    deployed = task_vars['previousDeployed']
    context = task_vars['context']

    client = CFClient.new_instance(deployed.container)
    if client.wait_for_terminated_status(deployed, context):
        print("Stack '%s' deleted." % deployed.name)
    else:
        print("Stack '%s' does not exist. Skipping." % deployed.name)


if __name__ == '__main__' or __name__ == '__builtin__':
    process(locals())
