from ec2.instance.ec2_instance_helper import EC2InstanceHelper
ec2_helper = EC2InstanceHelper(deployed)

descr="Create instance %s on %s" % (deployed.instanceName if deployed.instanceName else deployed.name, deployed.container.name)
if ec2_helper.is_ni_with_0_index():
    descr="%s with network interface %s" % (descr, deployed.networkInterfaces[ec2_helper.ni_device_index_0])

context.addStepWithCheckpoint(steps.jython(
    description=descr,
    script="ec2/instance/ec2_create.py",
    order=80
), delta)

if deployed.securityGroup and ec2_helper.is_ni_with_0_index():
    context.addStepWithCheckpoint(steps.jython(
        description="Associate security groups with instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/instance/ec2_associate_security_groups.py",
        order=82
    ), delta)

if deployed.attachElasticIp:
    context.addStepWithCheckpoint(steps.jython(
        description="Create elastic IP for instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/create_elastic_ip.py",
        order=82
    ), delta)
    context.addStepWithCheckpoint(steps.jython(
        description="Associate elastic IP with instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/associate_elastic_ip.py",
        order=83
    ), delta)

context.addStep(steps.jython(
    description="Wait for instance %s to be running" % (deployed.instanceName if deployed.instanceName else deployed.name),
    script="ec2/instance/ec2_create_running.py",
    order=81,
    jython_context = {"operation": delta.operation}
))

if deployed.networkInterfaces:
    for key, value in deployed.networkInterfaces.items():
        if key != EC2InstanceHelper.ni_device_index_0:
            context.addStep(steps.jython(
                description="Attach network interface %s to %s instance" % (value, deployed.instanceName if deployed.instanceName else deployed.name),
                script="ec2/ni/attach_network_interface.py",
                order=84,
                jython_context = {"device_index": key, "network_interface": value}
            ))

if deployed.volumes:
    for key, value in deployed.volumes.items():
        context.addStep(steps.jython(
            description="Attach volume %s to instance %s" % (key, deployed.instanceName if deployed.instanceName else deployed.name),
            script="ec2/ebs/ec2_attach_volume.py",
            order=84,
            jython_context = {"volume_id_name": key, "device": value}
        ))

context.addStep(steps.jython(
    description="Wait for instance %s to be fully booted" % (deployed.instanceName if deployed.instanceName else deployed.name),
    script="ec2/instance/ec2_fully_booted.py",
    order=85
))
