from ecs import ECSHelper
import re

class ECSContainerInstanceHelper(ECSHelper):
    def __init__(self, deployed):
        super(ECSContainerInstanceHelper, self).__init__(deployed)

    def is_instance_registered_in_cluster(self):
        container_instances_arns = self.ecs_client.list_container_instances(cluster=self.deployed.clusterName)['containerInstanceArns']
        container_instances = self.ecs_client.describe_container_instances(cluster=self.deployed.clusterName, containerInstances=container_instances_arns) ['containerInstances']

        if not self.__is_instance_avilable(container_instances, self.deployed.instanceId):
            raise RuntimeError("Container instance {} not connected with cluster {}".format(self.deployed.instanceId, self.deployed.clusterName))
        elif not self.__is_instance_agent_connected(container_instances, self.deployed.instanceId):
            raise RuntimeError("Agent not connected for container instance {} on cluster {}".format(self.deployed.instanceId, self.deployed.clusterName))

        return True

    @staticmethod
    def __is_instance_avilable(container_instances, instance_id):
        instance = filter(lambda container_instance: container_instance['ec2InstanceId'] == instance_id, container_instances)
        return len(instance) == 1

    @staticmethod
    def __is_instance_agent_connected(container_instances, instance_id):
        instance = filter(lambda container_instance: container_instance['ec2InstanceId'] == instance_id and container_instance['agentConnected'], container_instances)
        return len(instance) == 1

    def enable_ecs_cluster_registeration(self):
        # Making sure User Data begins with shebang '#!/bin/bash'
        if not self.deployed.userData:
            self.deployed.userData="#!/bin/bash"
        else:
            if not re.match("^\s*#!/bin/bash", self.deployed.userData):
                self.deployed.userData = "#!/bin/bash\n%s" % self.deployed.userData
        # Append 'echo ECS_CLUSTER=cluster-name >> /etc/ecs/ecs.config' to User Data of ec2 instance
        # so that it may register itself with the ECS cluster on startup.
        self.deployed.userData = "%s\n echo ECS_CLUSTER=%s >> /etc/ecs/ecs.config" %(self.deployed.userData, self.deployed.clusterName)

