#
if previousDeployed:
    if deployed.region != previousDeployed.region or \
            deployed.availabilityZone != previousDeployed.availabilityZone or \
            deployed.size != previousDeployed.size or \
            deployed.volumeType != previousDeployed.volumeType or \
            deployed.iops != previousDeployed.iops or \
            deployed.encryption != previousDeployed.encryption or \
            deployed.snapshotId != previousDeployed.snapshotId or \
            deployed.kmsKeyId != previousDeployed.kmsKeyId or \
            deployed.volumeId != previousDeployed.volumeId:
        raise RuntimeError("Only volume name can be updated once created.")
    description = "Modify %s volume on %s" % (
    previousDeployed.volumeName if previousDeployed.volumeName else previousDeployed.name, deployed.container.name)
else:
    description = "Create %s volume on %s" % (
    deployed.volumeName if deployed.volumeName else deployed.name, deployed.container.name)
    context.addStepWithCheckpoint(steps.jython(
        description="Wait to ensure %s volume is created" % (
        deployed.volumeName if deployed.volumeName else deployed.name),
        script="ec2/ebs/fully_created.py",
        order=41
    ), delta)

context.addStepWithCheckpoint(steps.jython(
    description=description,
    script="ec2/ebs/create.py",
    order=40
), delta)
