# Raise exception if amiId, region, security groups, keyName, instanceBootRetryCount, subnet

if previousDeployed.amiId != deployed.amiId:
    raise RuntimeError("AMI id of an ec2 instance can not be modified.")
if previousDeployed.region != deployed.region:
    raise RuntimeError("Region of an ec2 instance can not be modified.")
if previousDeployed.securityGroup != deployed.securityGroup:
    raise RuntimeError("Security Groups of an ec2 instance can not be modified.")
if previousDeployed.keyName != deployed.keyName:
    raise RuntimeError("Key Name of an ec2 instance can not be modified.")
if previousDeployed.instanceBootRetryCount != deployed.instanceBootRetryCount:
    raise RuntimeError("Instance Boot Retry Count of an ec2 instance can not be modified.")
if previousDeployed.subnet != deployed.subnet:
    raise RuntimeError("Subnet of an ec2 instance can not be modified.")
if previousDeployed.availabilityZone != deployed.availabilityZone:
    raise RuntimeError("Availability zone of an ec2 instance can not be modified.")
if len (set(previousDeployed.volumes) - set(deployed.volumes)) > 0:
    raise RuntimeError("Volumes can not be updated on an existing EC2 instance. It's recommended to undeploy and deploy the provisioning package again.")

def add_modify_step():
    context.addStep(steps.jython(
        description="Modify properties of %s instance on %s" % (deployed.instanceName if deployed.instanceName else deployed.name, deployed.container.name),
        script="ec2/instance/ec2_modify.py",
        order=52
    ))

def add_create_elastic_ip_step():
    context.addStepWithCheckpoint(steps.jython(
        description="Create elastic IP for %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/create_elastic_ip.py",
        order=55
    ), delta)

def add_release_elastic_ip_step():
    context.addStepWithCheckpoint(steps.jython(
        description="Release elastic IP %s" % (previousDeployed.publicIp),
        script="ec2/elastic_ip/release_elastic_ip.py",
        order=54
    ), delta)

def add_associate_elastic_ip_step():
    context.addStepWithCheckpoint(steps.jython(
        description="Associate elastic IP with instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/associate_elastic_ip.py",
        order=56
    ), delta)

restart = False

# Adding restart step if modified properties needs restart
if previousDeployed.instanceType != deployed.instanceType or \
        previousDeployed.tenancy != deployed.tenancy or \
        (previousDeployed.attachElasticIp and not deployed.attachElasticIp) or \
        previousDeployed.userData != deployed.userData:
    context.addStep(steps.jython(
        description="Stop instance %s on %s" % (previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name, previousDeployed.container.name),
        script="ec2/instance/ec2_stop.py",
        order=50
    ))
    context.addStep(steps.jython(
        description="Wait for %s instance to be in a stopped state" % (previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
        script="ec2/instance/ec2_instance_stopped.py",
        order=51
    ))
    context.addStep(steps.jython(
        description="Start instance %s on %s" % (deployed.instanceName if deployed.instanceName else deployed.name, deployed.container.name),
        script="ec2/instance/ec2_start.py",
        order=53
    ))
    context.addStep(steps.jython(
        description="Wait for %s instance to be in a running state" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/instance/ec2_create_running.py",
        order=59
    ))
    context.addStep(steps.jython(
        description="Wait to ensure the %s instance is fully booted" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/instance/ec2_fully_booted.py",
        order=60
    ))
    add_modify_step()
    restart = True
elif previousDeployed.iAmRoleARN != deployed.iAmRoleARN or \
        previousDeployed.shutdownBehavior != deployed.shutdownBehavior or \
        previousDeployed.detailedMonitoring != deployed.detailedMonitoring or \
        previousDeployed.terminationProtection != deployed.terminationProtection or \
        previousDeployed.instanceTags != deployed.instanceTags or \
        previousDeployed.instanceName != deployed.instanceName:
    add_modify_step()

if not deployed.networkInterfaces == previousDeployed.networkInterfaces:
    for key in set(previousDeployed.networkInterfaces.keys()) :
        context.addStep(steps.jython(
            description="Detach network interface %s from %s instance" % (previousDeployed.networkInterfaces.get(key), previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
            script="ec2/ni/detach_network_interface.py",
            order=56,
            jython_context = {"network_interface": previousDeployed.networkInterfaces.get(key)}
        ))
        context.addStep(steps.jython(
            description="Wait for network interface %s to be detached from %s instance" % (previousDeployed.networkInterfaces.get(key), previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
            script="ec2/ni/wait_detach_network_interface.py",
            order=57,
            jython_context = {"network_interface": previousDeployed.networkInterfaces.get(key)}
        ))
    for key in deployed.networkInterfaces.keys():
        context.addStep(steps.jython(
            description="Attach network interface %s to %s instance" % (deployed.networkInterfaces.get(key), deployed.instanceName if deployed.instanceName else deployed.name),
            script="ec2/ni/attach_network_interface.py",
            order=58,
            jython_context = {"device_index": key, "network_interface": deployed.networkInterfaces.get(key)}
        ))


for key in set(deployed.volumes) - set(previousDeployed.volumes):
    context.addStep(steps.jython(
        description="Attach volume %s to %s instance" % (key, previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
        script="ec2/ebs/ec2_attach_volume.py",
        order=58,
        jython_context = {"volume_id_name": key, "device": deployed.volumes.get(key)}
    ))

if previousDeployed.attachElasticIp and deployed.attachElasticIp and restart:
    add_associate_elastic_ip_step()
elif not previousDeployed.attachElasticIp and deployed.attachElasticIp:
    add_create_elastic_ip_step()
    add_associate_elastic_ip_step()
elif previousDeployed.attachElasticIp and not deployed.attachElasticIp:
    add_release_elastic_ip_step()
