import commons
from botocore.session import Session as BotocoreSession

from boto3.session import Session

class S3Helper(object):
    def __init__(self, deployed):
        self.deployed = deployed
        botocore_session = BotocoreSession()
        botocore_session.lazy_register_component('data_loader',
                                                 lambda: commons.create_loader())

        self.session = Session(aws_access_key_id=deployed.container.accesskey,
                               aws_secret_access_key=deployed.container.accessSecret,
                               botocore_session=botocore_session)

        if hasattr(self.deployed, 'region') and self.deployed.region is not None:
            self.s3 = self.session.resource('s3', region_name=self.deployed.region, use_ssl=False)
            self.s3_client = self.session.client('s3', region_name=self.deployed.region, use_ssl=False)

    def create_s3_bucket(self):
        print "Creating S3 bucket..."
        create_response = self.s3_client.create_bucket(
            Bucket=self.deployed.bucketName,
            CreateBucketConfiguration={
                'LocationConstraint': self.deployed.region
            }
        )
        return create_response

    def set_bucket_website_hosting(self):
        print "Setting S3 bucket website hosting..."
        hosting_response = self.s3_client.put_bucket_website(
            Bucket=self.deployed.bucketName,
            WebsiteConfiguration={
                'ErrorDocument': {
                    'Key': self.deployed.errorDocument
                },
                'IndexDocument': {
                    'Suffix': self.deployed.indexDocument
                }
            }
        )
        return hosting_response

    def set_bucket_logging(self):
        print "Setting S3 bucket logging..."
        logging_response = self.s3_client.put_bucket_logging(
            Bucket=self.deployed.bucketName,
            BucketLoggingStatus={
                'LoggingEnabled': {
                    'TargetBucket': self.deployed.targetBucket,
                    'TargetPrefix': self.deployed.targetPrefix
                }
            },
        )
        return logging_response

    def delete_s3_bucket(self):
        print "Deleting S3 bucket..."
        delete_response = self.s3_client.delete_bucket(
            Bucket=self.deployed.bucketName
        )
        return delete_response

    def disable_bucket_logging(self):
        print "Disabling S3 bucket logging..."
        logging_response = self.s3_client.put_bucket_logging(
            Bucket=self.deployed.bucketName,
            BucketLoggingStatus={}
        )
        return logging_response

    def disable_bucket_website_hosting(self):
        print "Disabling S3 bucket website hosting..."
        hosting_response = self.s3_client.delete_bucket_website(
            Bucket=self.deployed.bucketName)
        return hosting_response
