from ec2.sg.sg_helper import SGHelper

sg_helper = SGHelper(deployed)
inbound_modified = False
outbound_modified = False
verb = "Create"

# Validations for modify event
if previousDeployed:
    verb = "Modify"

    if deployed.securityGroupName != previousDeployed.securityGroupName:
        raise RuntimeError("Security group name can not be updated once created.")
    if deployed.description != previousDeployed.description:
        raise RuntimeError("Security group description can not be updated once created.")

    prev_sg_helper = SGHelper(previousDeployed)
    inbound_modified = prev_sg_helper.is_inbound_rules_exist()
    outbound_modified = prev_sg_helper.is_outbound_rules_exist()

# Validations for create or modify event
if sg_helper.is_inbound_rules_exist():
    inbound_modified = True
    is_vpc_not_provided = not sg_helper.is_vpc_provided()
    for rule in deployed.inboundRules:
        if is_vpc_not_provided:
            if rule.protocol == "-1":
                raise RuntimeError("Protocol -1 is not allowed for non VPC security group in inbound rule %s.", rule.name)
            if sg_helper.is_ipv6_cidr(rule.source):
                raise RuntimeError("IPv6 source is not allowed for non VPC security group in inbound rule %s.", rule.name)
        if not sg_helper.is_valid_port_range(rule.portRange):
            raise RuntimeError("Port range is not valid in inbound rule %s.", rule.name)

if sg_helper.is_outbound_rules_exist():
    outbound_modified = True
    if not sg_helper.is_vpc_provided():
        raise RuntimeError("Outbound rules are not allowed for non VPC security group.")

    for rule in deployed.outboundRules:
        if not sg_helper.is_valid_port_range(rule.portRange):
            raise RuntimeError("Port range is not valid in outbound rule %s.", rule.name)

# Steps for create event
if not previousDeployed:
    context.addStepWithCheckpoint(steps.jython(
        description="Create security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/create_security_group.py",
        order=53
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Apply properties to security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/apply_security_group_properties.py",
        order=55
    ), delta)


# Steps to modify rules for create or modify event
if inbound_modified:
    context.addStepWithCheckpoint(steps.jython(
        description="%s inbound rules in security group %s on %s" % (verb, deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/create_modify_inbound_rules.py",
        order=54
    ), delta)

if outbound_modified:
    context.addStepWithCheckpoint(steps.jython(
        description="%s outbound rules in security group %s on %s" % (verb, deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/create_modify_outbound_rules.py",
        order=54
    ), delta)
