from s3.s3_bucket_helper import S3Helper

s3_helper = S3Helper(deployed)
create_response = s3_helper.create_s3_bucket()

# Static website endpoint is available without even setting the static website properties,
# forming endpoint url here using bucket name and region.
if s3_helper.is_success(create_response):
    print "S3 bucket created."
    url = "%s.s3-website-%s.amazonaws.com" % (deployed.bucketName, deployed.region)
    deployed.endpoint = url

if deployed.policy and deployed.policy.strip():
    s3_helper.put_s3_bucket_policy()

if deployed.logging:
    logging_response = s3_helper.set_bucket_logging()

if deployed.staticWebsiteHosting:
    hosting_response = s3_helper.set_bucket_website_hosting()
