from aws_lambda.lambda_helper import LambdaHelper
import com.xebialabs.deployit.plugin.aws.LambdaZipHelper as LambdaZipHelper


class CustomLambdaHelper(LambdaHelper):
    def __init__(self, deployed):
        super(CustomLambdaHelper, self).__init__(deployed)
        self.lambda_zip_helper = LambdaZipHelper(deployed.container.accesskey, deployed.container.accessSecret, deployed.region)

    def get_function_create_request(self):
        request = self.lambda_zip_helper.buildCreateFunctionRequest();
        function_name = self.deployed.functionName if self.deployed.functionName else self.deployed.name

        request.setFunctionName(function_name)
        request.setRuntime(self.deployed.runtime)
        request.setHandler(self.deployed.handler)
        request.setRole(self.deployed.role)

        if self.deployed.description:
            request.setDescription(self.deployed.description)
        if self.deployed.timeout:
            request.setTimeout(self.deployed.timeout)

        if self.deployed.environment:
            for key, value in self.deployed.environment.items():
                self.lambda_zip_helper.addEnvironmentVariable(request, key, value)

        if self.deployed.kmsKeyArn:
            request.setKMSKeyArn(self.deployed.kmsKeyArn)
        if self.deployed.memorySize:
            request.setMemorySize(self.deployed.memorySize)

        if self.deployed.subnets:
            subnet_ids = self.ec2_helper.get_subnet_id_list(self.deployed.subnets)
            for subnet_id in subnet_ids:
                self.lambda_zip_helper.addSubnetId(request, subnet_id)
        if self.deployed.securityGroups:
            security_group_ids = self.ec2_helper.get_security_group_id_list(self.deployed.securityGroups)
            for security_group_id in security_group_ids:
                self.lambda_zip_helper.addSecurityGroupId(request, security_group_id)

        if self.deployed.deadLetterConfig:
            self.lambda_zip_helper.setDeadLetterConfig(request, self.deployed.deadLetterConfig)
        if self.deployed.tracingConfig:
            self.lambda_zip_helper.setTracingConfig(request, self.deployed.tracingConfig)

        if self.deployed.publish:
            request.setPublish(self.deployed.publish)
        if self.deployed.lambdaTags:
            for key, value in self.deployed.lambdaTags.items():
                self.lambda_zip_helper.addTag(request, key, value)

        return request

    def get_function_update_code_request(self):
        request = self.lambda_zip_helper.buildUpdateFunctionCodeRequest()
        function_name = self.deployed.functionName if self.deployed.functionName else self.deployed.name
        request.setFunctionName(function_name)

        if self.deployed.publish:
            request.setPublish(self.deployed.publish)

        return request

    def create_function_with_zip(self):
        print "Creating lambda function..."
        create_request = self.get_function_create_request()
        create_response = self.lambda_zip_helper.createZipFunction(create_request, self.deployed.file.path)
        return create_response

    def update_function_code_zip(self):
        update_request = self.get_function_update_code_request()
        update_response = self.lambda_zip_helper.updateFunctionCode(update_request, self.deployed.file.path)
        return update_response
