from alb.tg.tg_helper import TargetGroupHelper
from auto_scaling import *
from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from commons.aws_helper import AWSHelper


class ASGTargetGroupHelper(AWSHelper):
    def __init__(self, deployed, previous_deployed=None):
        super(ASGTargetGroupHelper, self).__init__(deployed)
        self.__client = self.get_aws_client(region=deployed.region, resource_name='autoscaling')
        self.__previous_deployed = previous_deployed
        self.__deployed = deployed
        self.__alb_tg_helper = TargetGroupHelper(deployed)
        self.__asg_helper = AutoScalingGroupHelper(deployed)

    def attach_target_groups(self):
        attached_target_groups = self.get_new_target_groups_attached()
        print "Adding target groups {0} to auto scaling group {1} on {2}".format(
            get_formatted_string(attached_target_groups),
            self.__asg_helper.get_asg_name(),
            self.deployed.container.name)
        return self.__client.attach_load_balancer_target_groups(
            AutoScalingGroupName=self.__asg_helper.get_asg_name(),
            TargetGroupARNs=self.__get_target_group_arns(self.get_new_target_groups_attached())
        )

    def detach_target_groups(self):
        detached_target_groups = self.get_detached_target_groups()
        print "Detaching target groups {0} from auto scaling group {1} on {2}".format(
            get_formatted_string(detached_target_groups),
            self.__asg_helper.get_asg_name(),
            self.deployed.container.name)

        return self.__client.detach_load_balancer_target_groups(
            AutoScalingGroupName=self.__asg_helper.get_asg_name(),
            TargetGroupARNs=self.__get_target_group_arns(self.get_detached_target_groups())
        )

    def __get_target_group_arns(self, target_groups):
        return map(lambda target_group_name: self.__alb_tg_helper.get_target_group_arn(target_group_name),
                   target_groups)

    def are_new_target_groups_attached(self):
        return bool(self.get_new_target_groups_attached())

    def are_target_groups_detached(self):
        return bool(self.get_detached_target_groups())

    def get_new_target_groups_attached(self):
        return (self.deployed.targetGroups - self.__previous_deployed.targetGroups) if bool(
            self.__previous_deployed) else self.deployed.targetGroups

    def get_detached_target_groups(self):
        return self.__previous_deployed.targetGroups - self.deployed.targetGroups
