/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.aws;

import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;

public class TrustExtractHelper {
    public static String extractTrustToPemString() {
        String pem = "";
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            trustManagerFactory.init((KeyStore)null);
            tmf.init((KeyStore)null);
            TrustManager[] tms = tmf.getTrustManagers();
            System.out.println(tms);
            System.out.println("JVM Default Trust Managers:");
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                System.out.println(trustManager);
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                for (X509Certificate cert : x509TrustManager.getAcceptedIssuers()) {
                    pem = pem + TrustExtractHelper.convertToPem(cert);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pem;
    }

    protected static String convertToPem(X509Certificate cert) throws CertificateEncodingException {
        Base64 encoder = new Base64(64);
        String cert_begin = "-----BEGIN CERTIFICATE-----\n";
        String end_cert = "-----END CERTIFICATE-----\n";
        byte[] derCert = cert.getEncoded();
        String pemCertPre = new String(encoder.encode(derCert));
        String pemCert = cert_begin + pemCertPre + end_cert;
        return pemCert;
    }
}

