import time
import copy
from Queue import Queue
from threading import Thread
class Worker(Thread):
    def __init__(self, tasks):
        Thread.__init__(self)
        self.tasks = tasks
        self.daemon = True
        self.start()

    def run(self):
        while True:
            func, args, kargs = self.tasks.get()
            try:
                func(*args, **kargs)
            except Exception, e:
                print e
            finally:
                self.tasks.task_done()


class ThreadPool:
    def __init__(self, num_threads):
        self.tasks = Queue(num_threads)
        for _ in range(num_threads):
            Worker(self.tasks)

    def add_task(self, func, *args, **kargs):
        self.tasks.put((func, args, kargs))

    def wait_completion(self):
        self.tasks.join()
def create_initial_deployment(task_to_create):
    app_id = task_to_create[1]
    env_id = task_to_create[2]
    user_name = task_to_create[3]
    run = task_to_create[4]

    depl_app = deployment.prepareInitial(app_id, env_id)
    depl_app = deployment.prepareAutoDeployeds(depl_app)
    task_id = deployment.createDeployTask(depl_app).id

    if user_name != 'admin':
        deployit.assignTask(task_id, user_name)

    if run:
        tasks_to_start.append(task_id)

    return task_id


def create_update_deployment(task_to_update):
    app_id = task_to_update[1]
    env_id = task_to_update[2]
    user_name = task_to_update[3]
    run = task_to_update[4]
    archive = task_to_update[5]

    depl_app = deployment.prepareUpgrade(app_id, env_id)
    depl_app = deployment.prepareAutoDeployeds(depl_app)
    task_id = deployment.createDeployTask(depl_app).id

    if user_name != 'admin':
        deployit.assignTask(task_id, user_name)

    if run:
        updated_tasks_to_start.append(task_id)

    if archive:
        tasks_to_archive.append(task_id)

    return task_id


def create_control_task_deployment(task_to_create):
    app_id = task_to_create[1]
    command_name = task_to_create[2]
    run = task_to_create[3]

    host4 = repository.read(app_id)
    control_task = deployit.prepareControlTask(host4, command_name)
    task_id = deployit.createControlTask(control_task)

    if run:
        tasks_to_start.append(task_id)

    return task_id


def schedule_initial_deployment(task_to_create):
    app_id = task_to_create[1]
    env_id = task_to_create[2]
    time = task_to_create[3]

    depl_app = deployment.prepareInitial(app_id, env_id)
    depl_app = deployment.prepareAutoDeployeds(depl_app)
    task_id = deployment.createDeployTask(depl_app).id
    task2.schedule(task_id, time)

    return task_id


def wait_till_no_active_tasks_left():
    wait = True

    while wait:
        print "Waiting for active tasks to complete."
        tasks_num = len(list(filter(lambda task: task.state.isActive() and task.state != TaskExecutionState.SCHEDULED,
                                    task2.getAllCurrentTasks())))
        print "At the moment %s running task(s)" % (tasks_num)
        wait = tasks_num > 0
        time.sleep(2)
cis_to_create_list = []
constructed_cis_list = []
packages_to_import = []
tasks_to_create = []
tasks_to_update = []
tasks_to_start = []
updated_tasks_to_start = []
cis_to_update = []
cis_to_grant_permissions = []
users_to_create = []
roles_to_assign = []
tasks_to_archive = []


def assign_role(role_name, principals=[]):
    roles_to_assign.append((role_name, principals))


def create_ci(id, type, properties=[]):
    cis_to_create_list.append((id, type, properties))


def create_user(username, password):
    users_to_create.append((username, password))


def update_ci(id, func):
    cis_to_update.append((id, func))


def create_initial_task(app_id, env_id, user_name='admin', run=True, archive=False):
    tasks_to_create.append(('initial', app_id, env_id, user_name, run, archive))


def upgrade_task(app_id, env_id, user_name='admin', run=True, archive=False):
    tasks_to_update.append(('upgrade', app_id, env_id, user_name, run, archive))


def create_control_task(app_id, command_name, run=True, archive=False):
    tasks_to_create.append(('control', app_id, command_name, run, archive))


def grant_permissions(permission, role_name, ci_ids=[]):
    cis_to_grant_permissions.append((permission, role_name, ci_ids))


def schedule_initial_task(app_id, env_id, time):
    tasks_to_create.append(('schedule', app_id, env_id, time))


def import_package(package_name):
    packages_to_import.append(package_name)


def bulk_construct_cis():
    for ci_to_create in cis_to_create_list:
        if ci_to_create[2]:
            constructed_cis_list.append(factory.configurationItem(ci_to_create[0], ci_to_create[1], ci_to_create[2]))
        else:
            constructed_cis_list.append(factory.configurationItem(ci_to_create[0], ci_to_create[1]))


def bulk_cis_creation():
    print "Creating CIs"
    bulk_construct_cis()
    repository.create(constructed_cis_list)


def bulk_import_packages():
    print "Importing packages"
    for package_to_import in packages_to_import:
        deployit.importPackage(package_to_import)


def bulk_cis_update():
    print "Updating CIs"
    for ci_to_update in cis_to_update:
        ci_id = ci_to_update[0]
        applyChanges = ci_to_update[1]

        ci = repository.read(ci_id)
        applyChanges(ci)
        repository.update(ci)


def bulk_create_tasks():
    print "Creating tasks"

    for task_to_create in tasks_to_create:
        task_type = task_to_create[0]
        if task_type == 'initial':
            task_id = create_initial_deployment(task_to_create)
            if task_to_create[5]:
                tasks_to_archive.append(task_id)
        elif task_type == 'control':
            task_id = create_control_task_deployment(task_to_create)
            if task_to_create[4]:
                tasks_to_archive.append(task_id)
        elif task_type == 'schedule':
            schedule_initial_deployment(task_to_create)
        else:
            raise Exception('Not supported task type ', task_type)

    bulk_start_tasks()


def bulk_update_tasks():
    print "Updating tasks"

    for task_to_update in tasks_to_update:
        create_update_deployment(task_to_update)

    bulk_updated_tasks_to_start()


def chunks(l, n):
    for i in range(0, len(l), n):
        yield l[i:i + n]


def _run_tasks(task_ids):
    chunk_num = 10
    total = len(task_ids)
    left_to_process = total
    for chuck_of_task_ids in list(chunks(task_ids, chunk_num)):
        for task_id in chuck_of_task_ids:
            task2.start(task_id)
        wait_till_no_active_tasks_left()
        left_to_process -= len(chuck_of_task_ids)
        print "Left to process % s out of %s" % (left_to_process, total)


def bulk_start_tasks():
    print "Starting the tasks (%s tasks)" % len(tasks_to_start)
    _run_tasks(tasks_to_start)


def bulk_updated_tasks_to_start():
    print "Starting to upgrade deployments (%s tasks)" % len(updated_tasks_to_start)
    _run_tasks(updated_tasks_to_start)


def bulk_grant_permission():
    print "Granting permissions"
    for ci_to_grant_permissions in cis_to_grant_permissions:
        permission = ci_to_grant_permissions[0]
        role_name = ci_to_grant_permissions[1]
        ci_ids = ci_to_grant_permissions[2]

        if ci_ids:
            security.grant(permission, role_name, ci_ids)
        else:
            security.grant(permission, role_name)


def bulk_create_users():
    print "Creating users"
    for user_to_create in users_to_create:
        security.createUser(user_to_create[0], user_to_create[1])


def bulk_roles_to_assign():
    print "Assigning roles"
    for role_to_assign in roles_to_assign:
        security.assignRole(role_to_assign[0], role_to_assign[1])


def bulk_tasks_archive():
    for task_to_archive in tasks_to_archive:
        task2.archive(task_to_archive)
create_ci('Configuration/credentials', 'credentials.UsernamePasswordCredentials',
                                            {'username': 'user', 'password': 'password'})
create_ci('Configuration/proxyHTTP', 'credentials.ProxyServer',
                                            {'protocol': 'HTTP', 'hostname': 'localhost', 'port': '3129'})
create_ci('Configuration/proxyHTTPS', 'credentials.ProxyServer',
                                            {'protocol': 'HTTPS', 'hostname': 'localhost', 'port': '3127'})

vaultFolder = 'Configuration/Vault'
create_ci(vaultFolder, 'core.Directory')
create_ci(vaultFolder + '/VaultServer', 'secrets.hashicorp.vault.Server', {
    'serverAddress': 'http://localhost:8201',
    'token': 'myroot'
})

create_ci(vaultFolder + '/VaultServer/SecretEngine', 'secrets.hashicorp.vault.SecretEngine', {
    'path': 'secret',
    'kvBackendVersion': 'VERSIONED'
})

create_ci(vaultFolder + '/VaultLookupValueProvider', 'secrets.hashicorp.vault.LookupValueProvider', {
    'vaultServer': vaultFolder + '/VaultServer',
    'secretPaths': ['secret/passwords']
})
create_user('john', 'john')
create_user('matt', 'matt')
create_user('charles', 'charles')
create_user('philip', 'philip')

create_user('login_man', 'login_man')
assign_role("Login_only", ["login_man"])
grant_permissions("login", "Login_only")

create_user('report_man', 'report_man')
assign_role("Report_only", ["report_man"])
grant_permissions("report#view", "Report_only")

create_user('security_man', 'security_man')
assign_role("Security_only", ["security_man"])
grant_permissions("security#edit", "Security_only")

create_user('report_security_man', 'report_security_man')
assign_role("Report_Security_only", ["report_security_man"])
grant_permissions("report#view", "Report_Security_only")
grant_permissions("security#edit", "Report_Security_only")

create_user('read_man', 'read_man')
assign_role("Cis_reader_only", ["read_man"])
grant_permissions("read", "Cis_reader_only", ['Applications', 'Environments', 'Configuration', 'Infrastructure'])

create_user('repo_edit_man', 'repo_edit_man')
assign_role("Cis_editors_only", ["repo_edit_man"])
grant_permissions("read", "Cis_editors_only", ['Applications', 'Environments', 'Configuration', 'Infrastructure'])
grant_permissions("repo#edit", "Cis_editors_only", ['Applications', 'Environments', 'Configuration', 'Infrastructure'])

create_user('import_remove_man', 'import_remove_man')
assign_role("App_removers", ["import_remove_man"])
grant_permissions("read", "App_removers", ['Applications'])
grant_permissions("import#remove", "App_removers", ['Applications'])

create_user('initial_deploy_man', 'initial_deploy_man')
assign_role("Initial_deployers_only", ["initial_deploy_man"])
grant_permissions("read", "Initial_deployers_only", ['Applications', 'Environments'])
grant_permissions("deploy#initial", "Initial_deployers_only", ['Environments'])

create_user('deploy_upgrade_man', 'deploy_upgrade_man')
assign_role("Deploy_Updaters_only", ["deploy_upgrade_man"])
grant_permissions("read", "Deploy_Updaters_only", ['Applications', 'Environments'])
grant_permissions("deploy#upgrade", "Deploy_Updaters_only", ['Environments'])

create_user('deploy_undeploy_man', 'deploy_undeploy_man')
assign_role("Deploy_Undeployers_only", ["deploy_undeploy_man"])
grant_permissions("read", "Deploy_Undeployers_only", ['Applications', 'Environments'])
grant_permissions("deploy#undeploy", "Deploy_Undeployers_only", ['Environments'])

create_user('task_view_man', 'task_view_man')
assign_role('Task_View_Only', ['task_view_man'])
grant_permissions('task#view', 'Task_View_Only')
grant_permissions('task#assign', 'Task_View_Only')
grant_permissions("deploy#initial", "Task_View_Only", ['Environments'])
grant_permissions("read", "Task_View_Only", ['Applications', 'Environments', 'Infrastructure'])

for i in range(1, 10):
    username = 'charles'+ str(i)
    create_user(username, username)
    assign_role('test_role'+ str(i), [username])

grant_permissions("login", "test_role1")
grant_permissions("login", "test_role2")

for i in range(11, 30):
    assign_role('test_role'+ str(i), ['test_role_principal'+ str(i)])

assign_role("Login_only", [
    "login_man", "report_man", "security_man", "report_security_man",
    "read_man", "repo_edit_man", 'initial_deploy_man', 'deploy_undeploy_man',
    'deploy_upgrade_man', 'import_remove_man', 'task_view_man'
])

assign_role("developers", ["john", "matt"])
assign_role("administrators", ["charles"])
assign_role("observer", ["philip", "john"])
grant_permissions("login", "developers")
grant_permissions("report#view", "administrators")
grant_permissions("admin", "administrators")
grant_permissions("task#preview_step", "developers")
grant_permissions('controltask#execute', 'administrators', ['Applications'])
grant_permissions('import#initial', 'administrators', ['Applications'])
grant_permissions('repo#edit', 'administrators', ['Applications'])
# Deployment packages

longString = ' very very very very very very very very very very very very very very very very very very very very very very very very very very very very very long string'

create_ci('Applications/AppForUpdateScenario', 'udm.Application')
create_ci('Applications/AppForHistory', 'udm.Application')
create_ci('Applications/AppWithArtifacts', 'udm.Application')
create_ci('Applications/AppWithEmbeddedDeployeds', 'udm.Application')
create_ci('Applications/CommandsFromDictionaryApp', 'udm.Application')
create_ci('Applications/CompositeApp', 'udm.Application')
create_ci('Applications/DependentTestApp', 'udm.Application')
create_ci('Applications/EmptyTestApp', 'udm.Application')
create_ci('Applications/ExampleApp', 'udm.Application')
create_ci('Applications/LongRunningApp', 'udm.Application')
create_ci('Applications/MultiCommandApp', 'udm.Application')
create_ci('Applications/MyPackage', 'udm.Application')
create_ci('Applications/WithoutPipeline', 'udm.Application')
create_ci('Applications/TestApp', 'udm.Application')
create_ci('Applications/SatelliteApp', 'udm.Application')
create_ci('Applications/TestAppWithInvalidDeployed', 'udm.Application')
create_ci("Applications/ZApp%s" % longString, 'udm.Application')
create_ci("Applications/Long\"Script\"App", 'udm.Application')
create_ci("Applications/CiWith%1", 'udm.Application')
create_ci("Applications/CiWith%%12", 'udm.Application')
create_ci("Applications/ToSchedule", 'udm.Application')
create_ci("Applications/BlankApp", 'udm.Application')
create_ci("Applications/XLApplication", 'xl.Application')
create_ci('Applications/AppForSameHostScenario', 'udm.Application')

create_ci('Applications/AppForUpdateScenario/1.0', 'udm.DeploymentPackage')
create_ci('Applications/AppForUpdateScenario/2.0', 'udm.DeploymentPackage')
create_ci('Applications/AppForUpdateScenario/3.0', 'udm.DeploymentPackage')
create_ci('Applications/AppForHistory/1.0', 'udm.DeploymentPackage')
create_ci('Applications/AppForHistory/2.0', 'udm.DeploymentPackage')
create_ci('Applications/AppForHistory/3.0', 'udm.DeploymentPackage')
create_ci('Applications/AppWithArtifacts/1.0', 'udm.DeploymentPackage')
create_ci('Applications/AppWithEmbeddedDeployeds/1.0', 'udm.DeploymentPackage')
create_ci('Applications/DependentTestApp/1.0', 'udm.DeploymentPackage',
          {'applicationDependencies': {'TestApp': '1.0'}})
create_ci('Applications/EmptyTestApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/ExampleApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/ExampleApp/2.0', 'udm.DeploymentPackage')
create_ci('Applications/LongRunningApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/MultiCommandApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/MyPackage/1.0', 'test-ci.MyPackage')
create_ci('Applications/WithoutPipeline/1.0', 'udm.DeploymentPackage')
create_ci('Applications/TestApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/TestAppWithInvalidDeployed/1.0', 'xl.DeploymentPackage')
create_ci('Applications/CommandsFromDictionaryApp/1.0', 'udm.DeploymentPackage')
create_ci("Applications/ZApp%s/1.0" % longString, 'udm.DeploymentPackage')
create_ci("Applications/Long\"Script\"App/1.0", 'udm.DeploymentPackage')
create_ci("Applications/CiWith%1/1.0", 'udm.DeploymentPackage')
create_ci("Applications/CiWith%%12/1.0", 'udm.DeploymentPackage')
create_ci("Applications/ToSchedule/1.0", 'udm.DeploymentPackage')
create_ci("Applications/XLApplication/1.0", 'udm.DeploymentPackage')
create_ci("Applications/XLApplication/2.0", 'udm.DeploymentPackage')
create_ci("Applications/XLApplication/3.0", 'udm.DeploymentPackage')
create_ci('Applications/CompositeApp/1.0', 'udm.CompositePackage', {
    'packages': ['Applications/LongRunningApp/1.0', 'Applications/TestApp/1.0']})
create_ci("Applications/AppForSameHostScenario/1.0", 'udm.DeploymentPackage')

for i in range(1, 100):
    appId = 'Applications/SatelliteApp/' + str(i) + '.0'
    create_ci(appId, 'udm.DeploymentPackage')
    create_ci(appId + '/cmd', 'cmd.Command', {'commandLine': 'sleep 1'})

create_ci('Applications/TestApp/1.0/Command', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 3'})
create_ci('Applications/DependentTestApp/1.0/SomeCommand', 'cmd.Command', {'commandLine': 'date'})
create_ci('Applications/TestAppWithInvalidDeployed/1.0/InvalidCommand', 'cmd.Command',
          {'name': 'Command', 'undoCommandLine': 'sleep 3'})
create_ci('Applications/TestAppWithInvalidDeployed/1.0/commandWithPlaceholder', 'cmd.Command',
          {'name': 'Command', 'undoCommandLine': '{{PLACE_HOLDER}}'})
create_ci('Applications/XLApplication/1.0/CommandForApplication', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 3'})
create_ci('Applications/XLApplication/2.0/CommandForApplication', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 3'})
create_ci('Applications/XLApplication/3.0/CommandForApplication', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 3'})

for x in range(1, 5):
    create_ci("Applications/LongRunningApp/1.0/SleepCommand%d" % x, 'cmd.Command',
              {'commandLine': 'sleep 3'})
    create_ci("Applications/CommandsFromDictionaryApp/1.0/cmd%d" % x, 'cmd.Command',
              {'commandLine': '{{cmd}}'})

for x in range(1, 15):
    create_ci("Applications/MultiCommandApp/1.0/cmd%d" % x, 'cmd.Command',
              {'commandLine': 'sleep 1'})

create_ci('Applications/AppWithArtifacts/1.0/google', 'file.File',
          {'fileUri': 'https://www.google.com'})
create_ci('Applications/AppWithEmbeddedDeployeds/1.0/Primary', 'example.ExamplePrimary')
create_ci('Applications/AppWithEmbeddedDeployeds/1.0/Primary/Embedded',
          'example.PrimaryEmbeddedDeployed')
create_ci('Applications/AppWithEmbeddedDeployeds/1.0/Primary/Embedded/Secondary',
          'example.EmbeddedVolumeSpec')
create_ci('Applications/ExampleApp/1.0/google', 'example.Artifact',
          {'fileUri': 'https://www.google.com'})
create_ci('Applications/Long\"Script\"App/1.0/LongScript', 'example.LongScriptDeployable')

create_ci('Applications/AppForUpdateScenario/1.0/SleepCommand1', 'cmd.Command',
          {'commandLine': 'sleep 10'})
create_ci('Applications/AppForUpdateScenario/2.0/SleepCommand2', 'cmd.Command',
          {'commandLine': 'sleep 3'})
create_ci('Applications/AppForUpdateScenario/3.0/SleepCommand3', 'cmd.Command',
          {'commandLine': 'sleep 5'})
create_ci('Applications/AppForUpdateScenario/3.0/SleepCommand3_1', 'cmd.Command',
          {'commandLine': 'sleep 5'})
for x in range(1, 5):
    create_ci("Applications/ZApp%s/1.0/Cmd%d %s" % (longString, x, longString), 'cmd.Command',
              {'commandLine': 'ls'})

create_ci('Applications/ToDeploy', 'core.Directory')

for x in range(1, 10):
    create_ci("Applications/ToDeploy/AppToDeploy%s" % x, 'udm.Application')
    create_ci("Applications/ToDeploy/AppToDeploy%s/1.0" % x, 'udm.DeploymentPackage')
    create_ci("Applications/ToDeploy/AppToDeploy%s/1.0/myCommand-%s" % (x, x), 'cmd.Command',
              {'commandLine': 'sleep 1'})

create_ci("Applications/AppForSandbox", 'udm.Application')
create_ci("Applications/AppForSandbox/1.0", 'udm.DeploymentPackage')
create_ci("Applications/AppForSandbox/1.0/staging-cmd", 'cmd.Command', {'commandLine': 'sleep 1'})

create_ci('Applications/DependentApp', 'udm.Application')
create_ci('Applications/AppWithDependentApp', 'udm.Application')
create_ci('Applications/DependentApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/AppWithDependentApp/1.0', 'udm.DeploymentPackage',
          {'applicationDependencies': {'DependentApp': '1.0'}})
create_ci('Applications/DependentApp/1.0/Command', 'cmd.Command', {'commandLine': '{{cmd}}'})

## DEPL-14469
create_ci('Applications/DEPL-14469', 'core.Directory')
create_ci('Applications/DEPL-14469/DEPL-14469-1', 'udm.Application')
create_ci('Applications/DEPL-14469/DEPL-14469-1/1.0', 'udm.DeploymentPackage')
create_ci('Applications/DEPL-14469/DEPL-14469-1/1.0/SleepCommand1', 'cmd.Command', {'commandLine': 'sleep 3'})

create_ci('Applications/DEPL-14469/DEPL-14469-2', 'udm.Application')
create_ci('Applications/DEPL-14469/DEPL-14469-2/1.0', 'udm.DeploymentPackage')
create_ci('Applications/DEPL-14469/DEPL-14469-2/1.0/SleepCommand2', 'cmd.Command', {'commandLine': 'sleep 5'})

create_ci('Applications/DEPL-14469/DEPL-14469-composite', 'udm.Application')
create_ci('Applications/DEPL-14469/DEPL-14469-composite/1.0', 'udm.CompositePackage', {
    'packages': ['Applications/DEPL-14469/DEPL-14469-1/1.0', 'Applications/DEPL-14469/DEPL-14469-2/1.0']
})

create_ci('Applications/AppToRename', 'udm.Application')
create_ci('Environments/Defaults', 'udm.Dictionary',
          {
              'entries': {'usr': 'admin', 'PLACE_HOLDER': 'value'},
              'encryptedEntries': {'secret': 'superSecureValue'}
          })

create_ci('Environments/HistoryDict', 'udm.Dictionary', {'entries': {'one': '1'}})


def update2(ci):
    ci['entries']['two'] = '2'


def update3(ci):
    ci['entries']['three'] = '3'


def update4(ci):
    ci['entries']['four'] = '4'


update_ci('Environments/HistoryDict', update2)
update_ci('Environments/HistoryDict', update3)
update_ci('Environments/HistoryDict', update4)

# Infra and Environment
configurationOvertherSshHost = {
    'address': 'localhost',
    'connectionType': 'SUDO',
    'os': 'UNIX',
    'password': 'root',
    'port': '12345',
    'sudoUsername': 'root',
    'username': 'root'
}
hosts = []
hostDicts = ['Environments/Defaults']
for x in range(1, 21):
    hostId = "Infrastructure/host%d" % x
    if x == 6:
        host6dict = copy.deepcopy(configurationOvertherSshHost)
        host6dict['satellite'] = 'Infrastructure/Satellite/LocalSatelliteGroup'
        create_ci(hostId, 'overthere.SshHost', host6dict)
    else:
        create_ci(hostId, 'overthere.SshHost', configurationOvertherSshHost)
    hosts.append(hostId)
    if x < 3:
        command = "sleep 5" if x % 2 == 1 else "bedtime five"
        create_ci("Environments/hostdict%d" % x, 'udm.Dictionary',
                  {'entries': {'cmd': command},
                   'restrictToContainers': [hostId]})
        hostDicts.append("Environments/hostdict%d" % x)

sameHostId = "Infrastructure/sameHost"
create_ci(sameHostId, 'overthere.SshHost', configurationOvertherSshHost)
create_ci('Environments/EnvsWithSameHost', 'core.Directory')
for x in range(1, 21):
    envId = "Environments/EnvsWithSameHost/EnvWithSameHost%d" % x
    create_ci(envId, 'udm.Environment',
              {'dictionaries': ['Environments/Defaults'], 'members': [sameHostId]})

create_ci('Environments/Env1', 'udm.Environment', {'dictionaries': ['Environments/Defaults']})
create_ci('Environments/EnvWithRequiredChecklist', 'udm.Environment',
            {
                'dictionaries': ['Environments/Defaults'],
                'members': ['Infrastructure/host12'],
                'requiresReleaseNotes': True,
                'requiresPerformanceTested': True,
                'requiresChangeTicketNumber': True,
                'requiresTestValueOne': True,
                'requiresTestValueTwo': True,
                'requiresTestValueThree': True,
                'requiresTestValueFour': True,
                'requiresTestValueFive': True,
                'requiresTestValueSix': True,
                'requiresTestValueSeven': True,
                'requiresTestValueEight': True,
                'requiresTestValueNine': True,
                'requiresTestValueTen': True,
            })
create_ci('Environments/MultiHostEnv', 'udm.Environment',
          {'members': hosts[3:5], 'dictionaries': ['Environments/Defaults']})
create_ci('Environments/Staging', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'], 'members': ['Infrastructure/host2']})
create_ci('Environments/Sandbox', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'], 'members': ['Infrastructure/host2']})
create_ci('Environments/StagingNoDefaults', 'udm.Environment',
          {'members': ['Infrastructure/host3']})
create_ci('Environments/TestDirEnv', 'core.Directory', {'dictionaries': ['Environments/Defaults']})
create_ci('Environments/TestDirEnv/Env2', 'udm.Environment', {'dictionaries': ['Environments/Defaults']})
create_ci('Environments/EnvWithDictionaries', 'udm.Environment',
          {'dictionaries': hostDicts, 'members': hosts[9:11]})

create_ci('Infrastructure/HostForUpdateScenario',
          'overthere.SshHost', configurationOvertherSshHost)
create_ci('Environments/EnvForUpdateScenario', 'xl.Environment',
          {'members': ['Infrastructure/HostForUpdateScenario'], 'dictionaries': ['Environments/Defaults']})

create_ci('Infrastructure/ExampleHost', 'overthere.SshHost', configurationOvertherSshHost)
create_ci('Infrastructure/ExampleHost/ExampleServer', 'example.Server', {'home': '/tmp'})

create_ci('Infrastructure/ExampleHostWithTags', 'overthere.SshHost',
          {
              'address': 'localhost',
              'connectionType': 'SUDO',
              'os': 'UNIX',
              'password': 'root',
              'port': '12345',
              'sudoUsername': 'root',
              'username': 'root',
              'tags': ['tag1', 'tag2', 'hostTag', 'deployTag']
          })

members = ['Infrastructure/ExampleHost', 'Infrastructure/ExampleHost/ExampleServer',
           'Infrastructure/ExampleHostWithTags']
for i in range(1, 10):
    hostId = 'Infrastructure/ExampleHostWithTags' + str(i)
    create_ci(hostId, 'overthere.SshHost',
              {
                  'address': 'localhost',
                  'connectionType': 'SUDO',
                  'os': 'UNIX',
                  'password': 'root',
                  'port': '12345',
                  'sudoUsername': 'root',
                  'username': 'root',
                  'tags': ['tag1', 'tag2', 'tag' + str(i)]
              })

    members.append(hostId)

create_ci('Environments/EnvForExampleHostWithTags', 'xl.Environment',
          {'members': members})

create_ci('Environments/EnvForExampleHost', 'xl.Environment',
          {'members': ['Infrastructure/ExampleHost', 'Infrastructure/ExampleHost/ExampleServer']})

tc_host_id = 'Infrastructure/TcHost'
create_ci(tc_host_id, 'overthere.SshHost', configurationOvertherSshHost)
tc_server_id = 'Infrastructure/TcHost/TcServer'
create_ci(tc_server_id, 'tc.Tomcat', {'home': '/etc/'})
create_ci('Environments/TcEnvHost', 'xl.Environment', {'members': [tc_host_id, tc_server_id]})

create_ci('Infrastructure/jboss-host', 'overthere.SshHost',
          {
              'address': 'jboss-7',
              'connectionType': 'SFTP',
              'os': 'UNIX',
              'password': 'centos',
              'username': 'root'
          })

create_ci('Infrastructure/jboss-host/jboss-domain', 'jbossdm.Domain',
          {
              'home': '/opt/jboss/7',
              'host': 'Infrastructure/jboss-host',
              'password': 'jboss',
              'username': 'jbossAdmin'
          })

dictionariesFolder = 'Environments/MultipleDictionaries'
multipleDictionariesFolder = dictionariesFolder + '/Dictionaries'
create_ci(dictionariesFolder, 'core.Directory')
create_ci(multipleDictionariesFolder, 'core.Directory')

dictionaryIds = []
for x in range(1, 16):
    dictId = multipleDictionariesFolder + '/Dict' + str(x)
    dictionaryIds.append(dictId)
    create_ci(dictId, 'udm.Dictionary')

create_ci(dictionariesFolder + '/MultiDictionaryEnvironment', 'xl.Environment', {'dictionaries': dictionaryIds})

def addLookup(ci):
    provider = repository.read('Configuration/Vault/VaultLookupValueProvider')
    ci.lookup["password"] = provider, "HOST_PASSWD"

vaultFolder = 'Infrastructure/Vault'
create_ci(vaultFolder, 'core.Directory')
create_ci(vaultFolder + '/Host', 'overthere.SshHost', {
    'externalProperties': {
        'password': {
            'kind': 'lookup',
            'provider': 'Configuration/Vault/VaultLookupValueProvider',
            'key': 'HOST_PASSWD'
        }
    },
    'address': 'localhost',
    'connectionType': 'SUDO',
    'os': 'UNIX',
    'port': '12345',
    'sudoUsername': 'root',
    'username': 'root',
    'tags': []
})

update_ci(vaultFolder + '/Host', addLookup)
create_ci('Applications/ProvisioningPackage', 'udm.Application')
create_ci('Applications/ProvisioningPackage/1.0', 'udm.ProvisioningPackage')

create_ci('Applications/ProvisioningPackage/1.0/Spec', 'aws.ec2.InstanceSpec',
          {'amiId': 'ami-d91be1ae', 'region': 'eu-west-1', 'securityGroup': 'default',
           'instanceType': 'm1.small'})

create_ci('Applications/ProvisioningPackage/1.0/SshHost', 'template.overthere.SshHost',
          {'os': 'UNIX', 'connectionType': 'SUDO', 'address': '{{%publicHostname%}}',
           'username': 'ubuntu'})

create_ci('Applications/ProvisioningPackage/1.0/SshHost/Tomcat', 'template.tomcat.Server',
          {'home': '/opt/apache-tomcat', 'startCommand': 'sh bin/startup.sh',
           'stopCommand': 'sh bin/shutdown.sh', 'startWaitTime': 10, 'stopWaitTime': 10})


def update_provis_spec(ci):
    ci.boundTemplates = ['Applications/ProvisioningPackage/1.0/SshHost']


update_ci('Applications/ProvisioningPackage/1.0/Spec', update_provis_spec)

create_ci('Applications/ProvisioningPackage/1.0/Spec/Manifest', 'puppet.provisioner.Manifest',
          {'hostTemplate': 'Applications/ProvisioningPackage/1.0/SshHost',
           'fileUri': 'https://www.google.com'})

create_ci('Applications/ProvisioningPackage/1.0/Spec/puppetlabs-tomcat',
          'puppet.provisioner.Module', {'name': 'puppetlabs-tomcat',
                                        'hostTemplate': 'Applications/ProvisioningPackage/1.0/SshHost'})

create_ci('Applications/ProvisioningPackage/1.0/Spec/puppetlabs-java',
          'puppet.provisioner.Module', {'name': 'puppetlabs-java',
                                        'hostTemplate': 'Applications/ProvisioningPackage/1.0/SshHost'})

create_ci('Infrastructure/AwsCloud', 'aws.Cloud',
          {'accesskey': 'accesskey', 'accessSecret': 'accessSecret'})

create_ci('Infrastructure/AwsEc2Cloud', 'aws.Cloud',
                            {'os': 'UNIX', 'accesskey': 'accesskey',
                             'accessSecret': 'accessSecret'})
create_ci('Environments/AwsEc2Environment', 'udm.Environment', {'members': ['Infrastructure/AwsEc2Cloud']})
create_ci('Infrastructure/DiscoverableHost', 'test-v3.DummyHost', {
    'numberOfSteps': '2',
    'amountOfKBLogFiles': '500',
    'stepDelayTimeInMilliSeconds': '0',
    'address': '4.2.2.1',
    'os': 'LINUX',
    'accessMethod': 'SSH',
    'username': 'admin',
    'password': 'qwerty'
})
create_ci('Configuration/ReleaseDeploymentPipeline', 'release.DeploymentPipeline', {
    'pipeline': ['Environments/Staging', 'Environments/MultiHostEnv', 'Environments/EnvWithDictionaries',
                 'Environments/EnvWithRequiredChecklist']})
create_ci('Applications/AppWithReleasePipeline', 'udm.Application',
          {'pipeline': 'Configuration/ReleaseDeploymentPipeline'})
create_ci('Applications/AppWithReleasePipeline/1.0', 'udm.DeploymentPackage')
create_ci('Applications/AppWithReleasePipeline/1.0/PipelineCommand', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 1'})
create_ci('Applications/AppWithReleasePipeline/2.0', 'udm.DeploymentPackage')
create_ci('Applications/AppWithReleasePipeline/2.0/PipelineCommand', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 2'})
create_ci('Applications/AppWithReleasePipeline/3.0', 'udm.DeploymentPackage')
create_ci('Applications/AppWithReleasePipeline/3.0/PipelineCommand', 'cmd.Command',
          {'commandLine': 'date', 'undoCommandLine': 'sleep 3'})

create_ci('Configuration/EmptyPipeline', 'release.DeploymentPipeline', {'pipeline': []})
create_ci('Applications/AppWithEmptyPipeline', 'udm.Application', {'pipeline': 'Configuration/EmptyPipeline'})
create_ci('Applications/AppWithEmptyPipeline/1.0', 'test-ci.MyPackage')
from org.joda.time import DateTime

longString = ' very very very very very very very very very very very very very very very very very very very very very very very very very very very very very long string'

create_initial_task('Applications/ExampleApp/1.0', 'Environments/Staging', 'matt', False)
schedule_initial_task('Applications/ToSchedule/1.0', 'Environments/Staging', DateTime().plusMonths(6))

create_initial_task('Applications/AppForUpdateScenario/1.0', 'Environments/Staging')
create_initial_task('Applications/DependentTestApp/1.0', 'Environments/Staging')
create_initial_task('Applications/EmptyTestApp/1.0', 'Environments/Staging')
create_initial_task('Applications/CiWith%1/1.0', 'Environments/Staging')
create_initial_task('Applications/CiWith%%12/1.0', 'Environments/Staging')
create_initial_task('Applications/Long"Script"App/1.0', 'Environments/Staging')
create_initial_task('Applications/TestApp/1.0', 'Environments/MultiHostEnv')
create_initial_task("Applications/ZApp%s/1.0" % longString, 'Environments/TestDirEnv/Env2', 'admin', True, True)
create_initial_task('Applications/AppForUpdateScenario/1.0', 'Environments/EnvForUpdateScenario', 'admin', True, True)
create_initial_task('Applications/AppForSandbox/1.0', 'Environments/Sandbox')

for i in range(1, 10):
    create_initial_task("Applications/ToDeploy/AppToDeploy%s/1.0" % i, 'Environments/Staging')

for i in range(1, 10):
    create_initial_task("Applications/ToDeploy/AppToDeploy%s/1.0" % i,
                        "Environments/EnvsWithSameHost/EnvWithSameHost%s" % i)

# Control tasks
for i in range(1, 5):
    create_control_task("Infrastructure/host" + str(i), 'checkConnection', True, True)

create_initial_task('Applications/AppWithReleasePipeline/1.0', 'Environments/Staging')

create_control_task('Infrastructure/host4', 'checkConnection', False)
create_control_task('Infrastructure/host5', 'checkConnection')
veryLongSatelliteName = 'SatelliteWithVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVery' \
                        'VeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVery' \
                        'VeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryLongName'

create_ci('Infrastructure/Satellite', 'core.Directory')

for i in range(1, 12):
    satelliteId = 'Infrastructure/Satellite/LocalSatellite' + str(i)
    create_ci(satelliteId, 'xl.Satellite', {'address': '127.0.0.1', 'protocolPort': '8380',
                                            'encrypted': 'false'})

    envId = 'Environments/EnvWithSatellite' + str(i)
    hostId = 'Infrastructure/satellite-host' + str(i)
    create_ci(hostId, 'overthere.SshHost',
              {
                  'address': 'localhost',
                  'connectionType': 'SUDO',
                  'os': 'UNIX',
                  'password': 'root',
                  'port': '12345',
                  'sudoUsername': 'root',
                  'username': 'root',
                  'satellite': satelliteId
              })

    create_ci(envId, 'udm.Environment',
              {'dictionaries': ['Environments/Defaults'],
               'members': [hostId]})

    for appVersion in range(1, 12):
        appId = 'Applications/SatelliteApp/' + str(appVersion) + '.0'
        create_initial_task(appId, envId, "admin", False)

    create_initial_task('Applications/AppForHistory/1.0', envId, "admin", False)
    create_initial_task('Applications/AppForHistory/2.0', envId, "admin", False)
    create_initial_task('Applications/AppForHistory/3.0', envId, "admin", False)
    create_initial_task('Applications/LongRunningApp/1.0', envId, "admin", False)
    create_initial_task('Applications/TestApp/1.0', envId, "admin", False)
    create_initial_task('Applications/AppForUpdateScenario/1.0', envId, "admin", False)
    create_initial_task('Applications/AppForUpdateScenario/2.0', envId, "admin", False)
    create_initial_task('Applications/AppForUpdateScenario/3.0', envId, "admin", False)
    create_initial_task('Applications/MultiCommandApp/1.0', envId, "admin", False)

create_ci('Infrastructure/Satellite/MisconfiguredSatellite', 'xl.Satellite',
          {'address': '127.0.0.1', 'protocolPort': '9999',
           'encrypted': 'false'})

create_ci('Infrastructure/Satellite/' + veryLongSatelliteName, 'xl.Satellite',
          {'address': '127.0.0.1', 'protocolPort': '8380',
           'encrypted': 'false'})
create_ci('Infrastructure/Satellite/XLSatelliteGroup', 'xl.SatelliteGroup',
          {'satellites': ['Infrastructure/Satellite/LocalSatellite1',
                          'Infrastructure/Satellite/LocalSatellite2',
                          'Infrastructure/Satellite/LocalSatellite3',
                          'Infrastructure/Satellite/LocalSatellite4',
                          'Infrastructure/Satellite/LocalSatellite5',
                          'Infrastructure/Satellite/LocalSatellite6',
                          'Infrastructure/Satellite/LocalSatellite7',
                          'Infrastructure/Satellite/LocalSatellite8',
                          'Infrastructure/Satellite/LocalSatellite9',
                          'Infrastructure/Satellite/LocalSatellite10',
                          'Infrastructure/Satellite/LocalSatellite11',
                          'Infrastructure/Satellite/' + veryLongSatelliteName,
                          'Infrastructure/Satellite/MisconfiguredSatellite']})

create_ci('Infrastructure/Satellite/LocalSatelliteGroup', 'xl.SatelliteGroup',
          {'satellites': ['Infrastructure/Satellite/LocalSatellite1',
                          'Infrastructure/Satellite/LocalSatellite2']})

create_ci('Infrastructure/group-host', 'overthere.SshHost',
          {
              'address': 'localhost',
              'connectionType': 'SUDO',
              'os': 'UNIX',
              'password': 'root',
              'port': '12345',
              'sudoUsername': 'root',
              'username': 'root',
              'satellite': 'Infrastructure/Satellite/LocalSatelliteGroup'
          })

create_ci('Environments/Group', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'],
           'members': ['Infrastructure/group-host']})
create_ci('Infrastructure/Satellite/MultiHostedSatelliteGroup', 'xl.SatelliteGroup',
          {'satellites': ['Infrastructure/Satellite/LocalSatellite1']})

create_ci('Infrastructure/Satellite/SatelliteGroupTeam', 'core.Directory')

for i in range(1, 15):
    create_ci('Infrastructure/Satellite/SatelliteGroupTeam/groupTeam-host-' + str(i),
              'overthere.SshHost',
              {
                  'address': 'localhost',
                  'connectionType': 'SUDO',
                  'os': 'UNIX',
                  'password': 'root',
                  'port': '12345',
                  'sudoUsername': 'root',
                  'username': 'root',
                  'satellite': 'Infrastructure/Satellite/MultiHostedSatelliteGroup'
              })

multiHostedSatelliteId = 'Infrastructure/Satellite/MultiHostedSatellite'
create_ci(multiHostedSatelliteId, 'xl.Satellite',
          {'address': '127.0.0.1', 'protocolPort': '8380',
           'encrypted': 'false'})

for teamLetter in ['A', 'B', 'C', 'D']:
    teamId = 'Infrastructure/Satellite/Team' + teamLetter
    create_ci(teamId, 'core.Directory')
    for i in range(1, 10):
        create_ci(teamId + '/team-' + teamLetter + '-host-' + str(i),
                  'overthere.SshHost',
                  {
                      'address': 'localhost',
                      'connectionType': 'SUDO',
                      'os': 'UNIX',
                      'password': 'root',
                      'port': '12345',
                      'sudoUsername': 'root',
                      'username': 'root',
                      'satellite': multiHostedSatelliteId
                  })

grant_permissions("read", "Cis_reader_only", ['Infrastructure/Satellite'])
grant_permissions("read", "Cis_reader_only", ['Infrastructure/Satellite/TeamA'])
grant_permissions("read", "Cis_reader_only", ['Infrastructure/Satellite/SatelliteGroupTeam'])
grant_permissions("read", "Task_View_Only", ['Infrastructure/Satellite'])

grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/TeamB'])
grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/TeamC'])
grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/TeamD'])
grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/SatelliteGroupTeam'])


def update_jboss_host(ci):
    ci.satellite = 'Infrastructure/Satellite/LocalSatellite1'


update_ci('Infrastructure/jboss-host', update_jboss_host)

create_ci('Environments/EnvWithSatelliteGroup', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'],
           'members': ['Infrastructure/host6']})

for appVersion in range(1, 12):
    appId = 'Applications/SatelliteApp/' + str(appVersion) + '.0'
    create_initial_task(appId, 'Environments/EnvWithSatelliteGroup', "admin", False)

# Create explorer.Satellite cis
for i in range(1, 2):
    satellite = 'Infrastructure/Satellite/ExpSatellite' + str(i)
    create_ci(
        satellite,
        'explorer.Satellite',
        {
            'address': '127.0.0.1',
            'protocolPort': '8380',
            'encrypted': 'false'
        }
    )

# Create explorer.SatelliteGroup cis
for i in range(1, 2):
    satellite = 'Infrastructure/Satellite/ExpSatelliteGroup' + str(i)
    create_ci(satellite, 'explorer.SatelliteGroup')
configurationOverthereSshHost = {
    'address': 'localhost',
    'connectionType': 'SUDO',
    'os': 'UNIX',
    'password': 'root',
    'port': '12345',
    'sudoUsername': 'root',
    'username': 'root'
}
create_ci('Applications/Placeholders', 'core.Directory')
create_ci('Environments/Placeholders', 'core.Directory')
placeholderDictsFolderId = 'Environments/Placeholders/Dictionaries'
placeholderTestDictsFolderId = 'Environments/Placeholders/Test-Dictionaries'
placeholderTestDictsFolderIdReadOnly = 'Environments/Placeholders/Test-Dictionaries-Read-Only'
create_ci(placeholderDictsFolderId, 'core.Directory')
create_ci(placeholderTestDictsFolderId, 'core.Directory')
create_ci(placeholderTestDictsFolderIdReadOnly, 'core.Directory')
create_ci('Infrastructure/Placeholders', 'core.Directory')

create_ci('Applications/Placeholders/PlaceholderNoDeployedsApp', 'udm.Application')
create_ci('Applications/Placeholders/PlaceholderNoDeployedsApp/1.0', 'placeholder.DeploymentPackage',
          {'dependencyResolution': '{{dependencyResolution}}'})

create_ci('Applications/Placeholders/PlaceholderNoDeployedsApp/2.0',
          'placeholder.DeploymentPackage', {'dependencyResolution': '{{dependencyResolution}}'})

create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds', 'udm.Application')

create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0',
          'placeholder.DeploymentPackage')
create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0/Command', 'xl.Command',
          {'commandLine': '{{cmd}}', 'secret': '{{secret}}', 'undoCommandLine': 'sleep 3'})

create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0',
          'placeholder.DeploymentPackage')
create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0/Command', 'xl.Command',
          {'commandLine': '{{cmd}}', 'secret': '{{secret}}', 'undoCommandLine': '{{multilineCmd}}'})

create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds', 'udm.Application')
create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0',
          'placeholder.DeploymentPackage')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0/Primary-{{primaryName}}',
    'example.ExamplePrimary')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}',
    'example.PrimaryEmbeddedDeployed')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}/Secondary-{{secondaryName}}',
    'example.EmbeddedVolumeSpec')

create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0',
          'placeholder.DeploymentPackage')
create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/PrimaryPlaceholder',
          'example.ExamplePrimary')

create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/Primary-{{primaryName}}',
    'example.ExamplePrimary')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}',
    'example.PrimaryEmbeddedDeployed')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}/Secondary-{{secondaryName}}',
    'example.EmbeddedVolumeSpec')

create_ci('Infrastructure/Placeholders/amsterdam-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/amsterdam-host/server', 'example.Server',
          {'home': '/tmp/amsterdam'})

create_ci('Infrastructure/Placeholders/haarlem-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/hilversum-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/zagreb-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/zagreb-host/server', 'example.Server',
          {'home': '/tmp/zagreb'})

create_ci('Infrastructure/Placeholders/split-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/dubrovnik-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci(placeholderDictsFolderId + '/Haarlem-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'ps -ef'
              },
              'restrictToContainers': [
                  'Infrastructure/Placeholders/haarlem-host'
              ]
          })

zagrebDictionary = create_ci(placeholderDictsFolderId + '/Zagreb-Dictionary', 'udm.Dictionary',
                             {
                                 'entries': {
                                     'cmd': 'df -h'
                                 },
                                 'restrictToContainers': [
                                     'Infrastructure/Placeholders/zagreb-host'
                                 ],
                                 'restrictToApplications': [
                                     'Applications/Placeholders/PlaceholderAppWithDeployeds'
                                 ]
                             })

create_ci(placeholderDictsFolderId + '/Dutch-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'date',
                  'dependencyResolution': 'LATEST',
                  'embeddedName': 'ENL',
                  'primaryName': 'PNL',
                  'secondaryName': 'SNL',
                  'usr': 'anki',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '%%_it_is_a_secret_%%'
              }
          })

create_ci(placeholderDictsFolderId + '/App-Restricted-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'pwd'
              },
              'restrictToApplications': [
                  'Applications/Placeholders/PlaceholderAppWithDeployeds'
              ]
          })

create_ci('Environments/Placeholders/Netherlands', 'xl.Environment',
          {
              'dictionaries': [
                  placeholderDictsFolderId + '/Haarlem-Dictionary',
                  placeholderDictsFolderId + '/App-Restricted-Dictionary',
                  placeholderDictsFolderId + '/Dutch-Dictionary'
              ],
              'members': [
                  'Infrastructure/Placeholders/amsterdam-host',
                  'Infrastructure/Placeholders/amsterdam-host/server',
                  'Infrastructure/Placeholders/haarlem-host',
                  'Infrastructure/Placeholders/hilversum-host'
              ]})

create_ci(placeholderDictsFolderId + '/Croatian-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'ls -al',
                  'multilineCmd': """# ghc-pkg-reset
                                # Removes all installed GHC/cabal packages, but not binaries, docs, etc.
                                # Use this to get out of dependency hell and start over, at the cost of some rebuilding time.
                                function ghc-pkg-reset() {
                                    read -p 'erasing all your user ghc and cabal packages - are you sure (y/n) ? ' ans
                                    test x$ans == xy && ( 
                                        echo 'erasing directories under ~/.ghc'; rm -rf `find ~/.ghc -maxdepth 1 -type d`;
                                        echo 'erasing ~/.cabal/lib'; rm -rf ~/.cabal/lib; 
                                        # echo 'erasing ~/.cabal/packages'; rm -rf ~/.cabal/packages; 
                                        # echo 'erasing ~/.cabal/share'; rm -rf ~/.cabal/share; 
                                        )
                                }""",
                  'dependencyResolution': 'EXISTING',
                  'embeddedName': 'ECR',
                  'primaryName': 'PCR',
                  'secondaryName': 'SCR',
                  'usr': 'anki',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              },
              'restrictToApplications': [
                  "Applications/Placeholders/PlaceholderAppWithDeployeds",
                  "Applications/Placeholders/PlaceholderNoDeployedsApp",
                  "Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds"
              ]
          })

create_ci('Environments/Placeholders/Croatia', 'xl.Environment',
          {
              'dictionaries': [
                  placeholderDictsFolderId + '/Zagreb-Dictionary',
                  placeholderDictsFolderId + '/Croatian-Dictionary'
              ],
              'members': [
                  'Infrastructure/Placeholders/zagreb-host',
                  'Infrastructure/Placeholders/zagreb-host/server',
                  'Infrastructure/Placeholders/dubrovnik-host',
                  'Infrastructure/Placeholders/split-host'
              ]
          })

create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary1', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command1',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary2', 'udm.Dictionary',
          {
              'entries': {
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'cmd': 'command2',
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderIdReadOnly + '/Vinodolski-Dictionary3', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command3',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderIdReadOnly + '/Vinodolski-Dictionary4', 'udm.Dictionary',
          {
              'entries': {
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'cmd': 'command4',
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary5', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command5',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary6', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command6',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary7', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command7',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })

create_initial_task('Applications/Placeholders/PlaceholderNoDeployedsApp/1.0', 'Environments/Placeholders/Netherlands')
upgrade_task('Applications/Placeholders/PlaceholderNoDeployedsApp/2.0',
             'Environments/Placeholders/Netherlands/PlaceholderNoDeployedsApp')

create_initial_task('Applications/Placeholders/PlaceholderNoDeployedsApp/1.0', 'Environments/Placeholders/Croatia')
upgrade_task('Applications/Placeholders/PlaceholderNoDeployedsApp/2.0',
             'Environments/Placeholders/Croatia/PlaceholderNoDeployedsApp')

create_initial_task('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0',
                    'Environments/Placeholders/Netherlands')
upgrade_task('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0',
             'Environments/Placeholders/Netherlands/PlaceholderAppWithDeployeds')

create_initial_task('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0', 'Environments/Placeholders/Croatia', 'admin', True, True)
upgrade_task('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0',
             'Environments/Placeholders/Croatia/PlaceholderAppWithDeployeds')

create_initial_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0',
                    'Environments/Placeholders/Netherlands')
upgrade_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0',
             'Environments/Placeholders/Netherlands/PlaceholderAppWithEmbeddedDeployeds')

create_initial_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0',
                    'Environments/Placeholders/Croatia')
upgrade_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0',
             'Environments/Placeholders/Croatia/PlaceholderAppWithEmbeddedDeployeds')

grant_permissions('task#takeover', 'test_role1', [placeholderDictsFolderId])
grant_permissions('read', 'test_role1', ['Environments/Placeholders'])
grant_permissions('read', 'test_role1', ['Infrastructure/Placeholders'])

grant_permissions('read', 'test_role2', ['Environments/Placeholders'])
grant_permissions('read', 'test_role2', [placeholderTestDictsFolderId])
grant_permissions('repo#edit', 'test_role2', [placeholderTestDictsFolderId])
grant_permissions('read', 'test_role2', [placeholderTestDictsFolderIdReadOnly])

def update_zagreb_dict(ci):
    ci['entries']['founded'] = 1094


update_ci(placeholderDictsFolderId + '/Zagreb-Dictionary', update_zagreb_dict)
create_ci('Applications/XL Deploy', 'core.Directory')
create_ci('Environments/XL Deploy', 'core.Directory')
create_ci('Infrastructure/XL Deploy', 'core.Directory')

create_ci('Infrastructure/XL Deploy/xl-deploy-nightly.xebialabs.com', 'overthere.SshHost',
                              {
                                  'address': 'localhost',
                                  'connectionType': 'SUDO',
                                  'os': 'UNIX',
                                  'password': 'root',
                                  'port': '12345',
                                  'sudoUsername': 'root',
                                  'username': 'root'
                              })

create_ci('Infrastructure/XL Deploy/xl-deploy-nightly.xebialabs.com/master', 'xl-deploy.Server',
                              {'installationHome': '/opt/xl/xld'})

create_ci('Environments/XL Deploy/XLD Master', 'udm.Dictionary',
                              {
                                  'entries': {'usr': 'admin', 'PORT': '4516'},
                                  'encryptedEntries': {'secret': 'superSecureValue'}
                              })

create_ci('Environments/XL Deploy/Nightly', 'udm.Environment',
                              {
                                  'dictionaries': ['Environments/XL Deploy/XLD Master'],
                                  'members': ['Infrastructure/XL Deploy/xl-deploy-nightly.xebialabs.com',
                                              'Infrastructure/XL Deploy/xl-deploy-nightly.xebialabs.com/master']
                              })

create_ci('Applications/XL Deploy/XL Deploy Base', 'udm.Application')
create_ci('Applications/XL Deploy/Ext', 'udm.Application')
create_ci('Applications/XL Deploy/GenerateData', 'udm.Application')
create_ci('Applications/XL Deploy/GenerationDataScripts', 'udm.Application')
create_ci('Applications/XL Deploy/License', 'udm.Application')
create_ci('Applications/XL Deploy/SetupDefaults', 'udm.Application')
create_ci('Applications/XL Deploy/XLDeployConf', 'udm.Application')
create_ci('Applications/XL Deploy/XLDSecurityConfig', 'udm.Application')

import_package('GenerateData-1.0.dar')
import_package('GenerationDataScripts-1.0.dar')
import_package('Ext-1.0.dar')
import_package('License-3.0.dar')
import_package('SetupDefaults-1.0.dar')
import_package('XLDeployConf-2.0.dar')
import_package('XLDSecurityConfig-1.0.dar')
import_package('XlsSystemConf-1.0.dar')
import_package('XL Deploy Base-8.6.0-alpha.29.dar')
import_package('KubernetesApp-1.0.dar')
import_package('postgresql-1.0.0.dar')

create_ci('Infrastructure/kubernetes-host', 'k8s.Master',
                          {'apiServerURL': 'http://dummy-url.com', 'os': 'UNIX'})

create_ci('Environments/KubernetesEnv', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'],
           'members': ['Infrastructure/kubernetes-host']})
bulk_cis_creation()
bulk_import_packages()
bulk_create_users()
bulk_roles_to_assign()
bulk_grant_permission()

bulk_create_tasks()
bulk_update_tasks()
bulk_cis_update()
bulk_tasks_archive()
