#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from cf.cf_executor import CfExecutor

previousDeployed = CfExecutor.set_cf_path_from_dict(previousDeployed, previousDeployedApplication)

context.addStep(steps.jython(
    description="Login into Cloud Foundry server [{}]".format(previousDeployed.container.container.apiEndpoint),
    order=55,
    script="cf/cf_login.py",
    jython_context={"deployed": previousDeployed.container},
    preview_script="cf/preview_login.py"
))

context.addStepWithCheckpoint(steps.jython(
    description="Update service [{}] on space [{}]".format(previousDeployed.name, previousDeployed.container.spaceName),
    order=57,
    script="cf/service/update_service.py",
    jython_context={"deployed": previousDeployed, "container": previousDeployed.container.container},
    preview_script="cf/service/planningScripts/preview_modify_service.py"
), delta)

context.addStep(steps.jython(
    description="Logout from Cloud Foundry server [{}]".format(previousDeployed.container.container.apiEndpoint),
    order=59,
    script="cf/cf_logout.py",
    jython_context={"deployed": previousDeployed.container},
    preview_script="cf/preview_logout.py"
))