from cf.app.helpers.app_steps_helper import AppStepsHelper
from cf.space.helpers.space_helper import SpaceHelper
from cf.app.helpers.app_helper import AppHelper
from java.lang import IllegalStateException
from cf.app.route.service.route_service import RouteService

app_steps_helper = AppStepsHelper(context, steps, delta, SpaceHelper.get_space_name(deployed.container))
app_steps_helper.add_step_for_create_app(deployed)

for bound_service in deployed.boundServices:
    app_steps_helper.add_step_for_bind_service(deployed.container, bound_service,
                                               AppHelper.get_app_name(deployed))

for route in deployed.routes:
    try:
        RouteService.create_route_request_builder(route, SpaceHelper.get_space_name(deployed.container)).build()
    except IllegalStateException as e:
        raise RuntimeError("Error in route {} : {}".format(route.name, e.getMessage()))

    app_steps_helper.add_step_for_create_route(deployed.container, route)
    app_steps_helper.add_step_for_bind_route(deployed.container, route, AppHelper.get_app_name(deployed))

app_steps_helper.add_step_for_start_app(deployed.container, AppHelper.get_app_name(deployed))
