from org.cloudfoundry.operations.services import CreateServiceInstanceRequest, DeleteServiceInstanceRequest, \
    CreateServiceKeyRequest, DeleteServiceKeyRequest, UpdateServiceInstanceRequest
from java.time import Duration
from cf.client import SpaceClient


class ServicesService(object):
    def __init__(self, container):
        self._space_client = SpaceClient.create_client(container).get_client()

    def create_services(self, service_name, plan_name, service_instance_name, service_tags, parameters, timeout):
        builder = CreateServiceInstanceRequest.builder().serviceName(service_name).planName(
            plan_name).serviceInstanceName(
            service_instance_name).tags(service_tags).parameters(parameters)
        if bool(timeout):
            builder.completionTimeout(Duration.create(timeout, 0))
        self._space_client.services().createInstance(builder.build()).block()

    def update_services(self, plan_name, service_instance_name, service_tags, parameters):
        self._space_client.services().updateInstance(
            UpdateServiceInstanceRequest.builder().planName(plan_name).serviceInstanceName(
                service_instance_name).tags(service_tags).parameters(parameters).build()).block()

    def destroy_services(self, service_instance_name):
        self._space_client.services().deleteInstance(
            DeleteServiceInstanceRequest.builder().name(service_instance_name).build()).block()

    def create_service_key(self, service_instance_name, service_key_name, parameters):
        self._space_client.services().createServiceKey(
            CreateServiceKeyRequest.builder().serviceInstanceName(service_instance_name).serviceKeyName(
                service_key_name).parameters(parameters).build()).block()

    def delete_service_key(self, service_instance_name, service_key_name):
        self._space_client.services().deleteServiceKey(
            DeleteServiceKeyRequest.builder().serviceInstanceName(service_instance_name).serviceKeyName(
                service_key_name).build()).block()
