class RouteHelper(object):
    @staticmethod
    def get_domain_name(route):
        domainName = route.domainName if route.domainName else route.name
        print("Found domain name %s for route %s" % (domainName, route))
        return domainName

    @staticmethod
    def get_route_url(route):
        print("Determining URL for route %s" % route)
        return '{0}{1}{2}'.format('{0}.'.format(route.hostName) if bool(route.hostName) else '',
                                  RouteHelper.get_domain_name(route),
                                  '/{0}'.format(route.path) if bool(route.path) else '')

    @staticmethod
    def contains_route(route_list, route):
        print("Checking if route %s exists in routes %s" % (route, route_list))
        for r in route_list:
            if RouteHelper.is_route_same(r, route):
                return True

    @staticmethod
    def is_route_same(old_route, new_route):
        return RouteHelper.get_domain_name(old_route) == RouteHelper.get_domain_name(
            new_route) and old_route.hostName == new_route.hostName and old_route.path == new_route.path and old_route.port == new_route.port and old_route.randomPort == new_route.randomPort
