from org.cloudfoundry.operations.routes import CreateRouteRequest, DeleteRouteRequest, MapRouteRequest, \
    UnmapRouteRequest
from cf.client import SpaceClient
from cf.app.route.helpers.route_helper import RouteHelper
from cf.space.helpers.space_helper import SpaceHelper
from java.lang import IllegalArgumentException, IllegalStateException

class RouteService(SpaceClient):
    def __init__(self, container):
        self.__space_client = SpaceClient.create_client(container).get_client()
        self.__space_name = SpaceHelper.get_space_name(container)

    def create_route(self, space_name, route):
        print "Creating route {} on space {}".format(RouteHelper.get_route_url(route), space_name)
        builder = self.create_route_request_builder(route, self.__space_name)
        self.__space_client.routes().create(builder.build()).block()

    @staticmethod
    def create_route_request_builder(route, space_name):
        builder = CreateRouteRequest.builder().domain(RouteHelper.get_domain_name(route)).host(
            route.hostName).path(
            route.path).port(route.port).space(
            space_name)
        if bool(route.randomPort):
            builder.randomPort(True)
        return builder

    def delete_route(self, space_name, route):
        print "Deleting route {} on space {}".format(RouteHelper.get_route_url(route), space_name)
        try:
            self.__space_client.routes().delete(
                DeleteRouteRequest.builder().domain(RouteHelper.get_domain_name(route)).host(
                    route.hostName).path(route.path).port(route.port).build()).block()
        except IllegalArgumentException as e:
            if "does not exist" in e.getMessage():
                print "Route {} does not exist. Ignoring deletion.".format(RouteHelper.get_route_url(route))
            else:
                raise e

    def map_application_to_route(self, route, app_name):
        print "Mapping app {} to route {}".format(app_name,
                                                  RouteHelper.get_route_url(route))
        builder = MapRouteRequest.builder().domain(RouteHelper.get_domain_name(route)).host(route.hostName).path(
            route.path).port(route.port).applicationName(app_name)
        if bool(route.randomPort):
            builder.randomPort(True)
        self.__space_client.routes().map(builder.build()).block()

    def unmap_application_from_route(self, route, app_name):
        print "Unmapping app {} from route {}".format(app_name, RouteHelper.get_route_url(route))
        try:
            self.__space_client.routes().unmap(
                UnmapRouteRequest.builder().domain(RouteHelper.get_domain_name(route)).host(route.hostName).path(
                    route.path).port(route.port).applicationName(app_name).build()).block()
        except (IllegalArgumentException, IllegalStateException) as e:
            if "does not exist" in e.getMessage() or "not mapped to application" in e.getMessage():
                print "Route {} does not exist. Ignoring unbinding.".format(RouteHelper.get_route_url(route))
            else:
                raise e
