package com.xebialabs.deployit.plugin.codepipeline.actions;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.codepipeline.services.XLDeployService;

public class PrepareAction extends Action<Deployment> {

    private final XLDeployService xlDeployService;
    private final String deploymentPackageId;
    private final String environmentId;
    private String actionName;

    public PrepareAction(XLDeployService xlDeployService, String deploymentPackageId, String environmentId) {
        this.xlDeployService = xlDeployService;
        this.deploymentPackageId = deploymentPackageId;
        this.environmentId = environmentId;
    }

    @Override
    public Deployment execute() {
        actionName = "Prepare Deployment";
        Deployment deployment = xlDeployService.prepareInitial(deploymentPackageId, environmentId);

        actionName = "Prepare Auto mapping";
        return xlDeployService.prepareAutoMapping(deployment);
    }

    @Override
    public String actionName() {
        return this.actionName;
    }
}
