/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.actions;

import com.amazonaws.service.codepipeline.model.Job;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.codepipeline.actions.Action;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.plugin.codepipeline.helpers.ConfigurationItemUtils;
import com.xebialabs.deployit.plugin.codepipeline.helpers.DarHelper;
import com.xebialabs.deployit.plugin.codepipeline.helpers.DarInfo;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;
import com.xebialabs.deployit.plugin.codepipeline.services.XLDeployService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAction
extends Action<ConfigurationItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportAction.class);
    private final CodePipelineJobService jobService;
    private final XLDeployService xlDeployService;
    private final Job job;
    private final String deploymentPackageName;
    private final String deploymentPackageVersion;

    public ImportAction(XLDeployService xlDeployService, CodePipelineJobService jobService, Job job, String deploymentPackageName, String deploymentPackageVersion) {
        this.xlDeployService = xlDeployService;
        this.jobService = jobService;
        this.job = job;
        this.deploymentPackageName = deploymentPackageName;
        this.deploymentPackageVersion = deploymentPackageVersion;
    }

    @Override
    public ConfigurationItem execute() {
        return this.validateAndImportArtifact(this.job, this.deploymentPackageName, this.deploymentPackageVersion);
    }

    @Override
    public String actionName() {
        return "Import package";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationItem validateAndImportArtifact(Job job, String deploymentPackageName, String deploymentPackageVersion) {
        Path path = this.jobService.getPackagePath(job);
        if (path == null) {
            throw new CodePipelinePluginExecutionException("Unable to get downloaded file path");
        }
        try {
            ConfigurationItem item;
            DarInfo info = DarHelper.getDarInfo(path);
            this.validateConfigurationItem(info, deploymentPackageName, deploymentPackageVersion);
            ConfigurationItem configurationItem = item = this.xlDeployService.importPackage(path);
            return configurationItem;
        }
        finally {
            this.cleanupFile(path);
        }
    }

    private void cleanupFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to delete temp file " + path.getFileName(), (Throwable)ex);
        }
    }

    private void validateConfigurationItem(DarInfo info, String deploymentPackageName, String deploymentPackageVersion) {
        if (info == null) {
            return;
        }
        this.validateVersion(info.getVersion(), deploymentPackageVersion);
        this.validateName(info.getName(), ConfigurationItemUtils.getNameFromId(deploymentPackageName));
    }

    private void validateVersion(String ciPackageVersion, String deploymentPackageVersion) {
        String string = deploymentPackageVersion = deploymentPackageVersion == null ? "" : deploymentPackageVersion;
        if (!deploymentPackageVersion.isEmpty() && !deploymentPackageVersion.equals(ciPackageVersion)) {
            throw new CodePipelinePluginExecutionException(String.format("Deployment Package version '%s' is different from packaged version '%s' inside S3 bucket", deploymentPackageVersion, ciPackageVersion));
        }
    }

    private void validateName(String ciPackageName, String deploymentPackageName) {
        if (!ciPackageName.equals(deploymentPackageName)) {
            throw new CodePipelinePluginExecutionException(String.format("Deployment Package name '%s' is different from packaged name '%s' inside S3 bucket", deploymentPackageName, ciPackageName));
        }
    }
}

