/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.actions;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.codepipeline.actions.Action;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.plugin.codepipeline.services.XLDeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDeploymentAction
extends Action<Deployment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateDeploymentAction.class);
    public static final String NEW_LINE = System.getProperty("line.separator");
    private final XLDeployService xlDeployService;
    private final Deployment deployment;

    public ValidateDeploymentAction(XLDeployService xlDeployService, Deployment deployment) {
        this.xlDeployService = xlDeployService;
        this.deployment = deployment;
    }

    @Override
    public Deployment execute() {
        Deployment validatedDeployment = this.xlDeployService.validateDeployment(this.deployment);
        this.checkValidationErrors(validatedDeployment);
        return validatedDeployment;
    }

    @Override
    public String actionName() {
        return "Validate deployment";
    }

    private void checkValidationErrors(Deployment deployment) {
        int validationMessagesFound = 0;
        StringBuilder builder = new StringBuilder();
        for (ConfigurationItem configurationItem : deployment.getDeployeds()) {
            if (configurationItem.get$validationMessages().size() == 0) continue;
            for (ValidationMessage msg : configurationItem.get$validationMessages()) {
                String message = String.format("Error found on configuration item '%s' on field '%s': %s", configurationItem.getId(), msg.getPropertyName(), msg.getMessage());
                LOGGER.error(message);
                builder.append(message);
                builder.append(" ");
                builder.append(NEW_LINE);
                ++validationMessagesFound;
            }
        }
        if (validationMessagesFound > 0) {
            String g = String.format("Found (%d) validation error(s) - %s", validationMessagesFound, builder.toString());
            throw new CodePipelinePluginExecutionException(String.format("Found (%d) validation error(s) - %s", validationMessagesFound, builder.toString()));
        }
    }
}

