package com.xebialabs.deployit.plugin.codepipeline.helpers;

import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.util.TFiles;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;


public abstract class DarHelper {


    public static DarInfo getDarInfo(Path path) {
        File packageFile = path.toFile();
        TFile manifest = new TFile(packageFile, "deployit-manifest.xml");
        try(TFileInputStream is = new TFileInputStream(manifest)) {
            SAXBuilder saxBuilder = new SAXBuilder();
            Element element = saxBuilder.build(is).getRootElement();
            return new DarInfo( element.getAttributeValue("application"), element.getAttributeValue("version"));
        } catch (JDOMException e) {
            throw new CodePipelinePluginExecutionException("Could not read manifest file, invalid xml.", e);
        } catch (IOException e) {
            throw new CodePipelinePluginExecutionException("Could not read manifest", e);
        } finally {
            TFiles.umountQuietly(manifest);
            TFiles.umountQuietly(new TFile(packageFile));
        }
    }

}
