/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.actions;

import com.amazonaws.services.codepipeline.model.Job;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.codepipeline.actions.Action;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.plugin.codepipeline.helpers.XldConfig;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;
import com.xebialabs.deployit.plugin.codepipeline.services.XLDeployService;
import java.util.Map;

public class CreateTaskAction
extends Action<String> {
    private final CodePipelineJobService jobService;
    private final XLDeployService xlDeployService;
    private final Job job;
    private final Deployment deployment;

    public CreateTaskAction(CodePipelineJobService jobService, XLDeployService xlDeployService, Job job, Deployment deployment) {
        this.jobService = jobService;
        this.xlDeployService = xlDeployService;
        this.job = job;
        this.deployment = deployment;
    }

    @Override
    public String execute() {
        return this.createTask(this.job, this.deployment);
    }

    @Override
    public String actionName() {
        return "Create Task";
    }

    private String createTask(Job job, Deployment deployment) {
        Map<String, String> jobData = this.jobService.getJobData(job);
        String taskId = this.xlDeployService.createTask(deployment, this.getXldConfig(jobData));
        if (taskId == null) {
            throw new CodePipelinePluginExecutionException("Unable to create XL Deploy task");
        }
        return taskId;
    }

    private XldConfig getXldConfig(Map<String, String> jobData) {
        String xldServerUrl = jobData.get("XL Deploy URL");
        String xldUsername = jobData.get("XL Deploy Username");
        String xldPassword = jobData.get("XL Deploy Password");
        return new XldConfig(xldServerUrl, xldUsername, xldPassword);
    }
}

