/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.configurations;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.codepipeline.helpers.BeansFactory;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;
import com.xebialabs.deployit.plugin.codepipeline.steps.CodePipelineStep;
import com.xebialabs.xlplatform.scheduler.CronPattern;
import com.xebialabs.xlplatform.scheduler.ci.StepJob;
import java.util.List;
import java.util.Map;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, description="AWS CodePipeline Job Worker")
public class CodePipelineJobWorker
extends StepJob {
    private static final String CODEPIPELINE_URL = "https://codepipeline.us-east-1.amazonaws.com";
    private static final String JOB_WORKER_CRON_SCHEDULE = "0 */1 * * * *";
    @Property(description="The URL on which AWS CodePipeline would be accessible i.e. https://codepipeline.us-east-1.amazonaws.com", defaultValue="https://codepipeline.us-east-1.amazonaws.com")
    private String codePipelineUrl;
    @Property(description="The access key to connect with AWS CodePipeline", password=true)
    private String accesskey;
    @Property(description="The access secret to connect with AWS CodePipeline", password=true)
    private String accessSecret;
    @Property(description="A key used to identify an XL Deploy server. Multiple CodePipeline jobs can use the same key so that an XLD server can process jobs with same key.")
    @Regex(pattern="[A-Za-z0-9.@\\-_]+")
    private String xlDeployServerKey;
    @CronPattern
    @Property(label="Crontab schedule", required=true, defaultValue="0 */1 * * * *", description="The pattern is a list of six single space-separated fields: representing second, minute, hour, day, month, weekday. Month and weekday names can be given as the first three letters of the English names.Example patterns: '0 0 * * * *' = the top of every hour of every day, '0 0 14 * * SAT,SUN' = 14 o'clock on each weekend day, '0 0 9-17 * * MON-FRI' = on the hour nine-to-five weekdays, '0 0 0 1 * *' = every 1st of month at midnight.")
    private String schedule;

    public List<Step> getSteps(Map<String, String> params) {
        CodePipelineJobService jobService = BeansFactory.codePipelineJobService(this);
        return Lists.newArrayList((Object[])new Step[]{new CodePipelineStep(this.xlDeployServerKey, jobService, BeansFactory.jobProcessor(jobService))});
    }

    public String getCodePipelineUrl() {
        return this.codePipelineUrl;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public String getXlDeployServerKey() {
        return this.xlDeployServerKey;
    }

    public String getSchedule() {
        return this.schedule;
    }
}

