/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.helpers;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.codepipeline.AWSCodePipelineClient;
import com.amazonaws.services.codepipeline.model.Job;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.codepipeline.actions.Action;
import com.xebialabs.deployit.plugin.codepipeline.actions.CreateTaskAction;
import com.xebialabs.deployit.plugin.codepipeline.actions.ExecuteTaskAction;
import com.xebialabs.deployit.plugin.codepipeline.actions.ImportAction;
import com.xebialabs.deployit.plugin.codepipeline.actions.PrepareAction;
import com.xebialabs.deployit.plugin.codepipeline.actions.UpdateAction;
import com.xebialabs.deployit.plugin.codepipeline.actions.ValidateDeploymentAction;
import com.xebialabs.deployit.plugin.codepipeline.configurations.CodePipelineJobWorker;
import com.xebialabs.deployit.plugin.codepipeline.helpers.RegionHelper;
import com.xebialabs.deployit.plugin.codepipeline.processor.JobProcessor;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;
import com.xebialabs.deployit.plugin.codepipeline.services.XLDeployService;

public abstract class BeansFactory {
    private static AWSCodePipelineClient codePipelineClient;
    private static CodePipelineJobService codePipelineJobService;
    private static XLDeployService xlDeployService;
    private static JobProcessor jobProcessor;

    public static AWSCodePipelineClient codePipelineClient(CodePipelineJobWorker configuration) {
        if (codePipelineClient == null) {
            codePipelineClient = new AWSCodePipelineClient((AWSCredentials)new BasicAWSCredentials(configuration.getAccesskey(), configuration.getAccessSecret()));
            codePipelineClient.setEndpoint(configuration.getCodePipelineUrl());
            codePipelineClient.setRegion(RegionHelper.getRegionFromEndpoint(configuration.getCodePipelineUrl()));
        }
        return codePipelineClient;
    }

    public static CodePipelineJobService codePipelineJobService(CodePipelineJobWorker configuration) {
        if (codePipelineJobService == null) {
            codePipelineJobService = new CodePipelineJobService(BeansFactory.codePipelineClient(configuration));
        }
        return codePipelineJobService;
    }

    public static XLDeployService xlDeployService() {
        return xlDeployService;
    }

    public static JobProcessor jobProcessor(CodePipelineJobService jobService) {
        if (jobProcessor == null) {
            jobProcessor = new JobProcessor(jobService, BeansFactory.xlDeployService());
        }
        return jobProcessor;
    }

    public static Action getUpdateAction(XLDeployService xlDeployService, String deploymentPackageId, String environmentId) {
        return new UpdateAction(xlDeployService, deploymentPackageId, environmentId);
    }

    public static Action getPrepareAction(XLDeployService xlDeployService, String deploymentPackageId, String environmentId) {
        return new PrepareAction(xlDeployService, deploymentPackageId, environmentId);
    }

    public static Action<String> getPrepareAction(CodePipelineJobService jobService, XLDeployService xlDeployService, Job job, Deployment deployment) {
        return new CreateTaskAction(jobService, xlDeployService, job, deployment);
    }

    public static Action<TaskExecutionState> getExecuteTaskAction(XLDeployService xlDeployService, String taskId) {
        return new ExecuteTaskAction(xlDeployService, taskId);
    }

    public static Action<ConfigurationItem> getImportAction(XLDeployService xlDeployService, CodePipelineJobService jobService, Job job, String deploymentPackageName, String deploymentPackageVersion) {
        return new ImportAction(xlDeployService, jobService, job, deploymentPackageName, deploymentPackageVersion);
    }

    public static Action getValidateDeploymentAction(XLDeployService xlDeployService, Deployment deployment) {
        return new ValidateDeploymentAction(xlDeployService, deployment);
    }

    static {
        xlDeployService = new XLDeployService(ServiceHolder.getPackageService(), ServiceHolder.getDeploymentService(), ServiceHolder.getTaskBlockService());
    }
}

