/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.helpers;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;

public abstract class RegionHelper {
    public static Region getRegionFromEndpoint(String endpoint) {
        try {
            return RegionUtils.getRegionByEndpoint((String)endpoint);
        }
        catch (IllegalArgumentException e) {
            return RegionHelper.parseUrlForRegion(endpoint);
        }
    }

    private static Region parseUrlForRegion(String endpoint) {
        try {
            return Region.getRegion((Regions)Regions.fromName((String)endpoint.split("\\.")[1]));
        }
        catch (Exception e) {
            throw new CodePipelinePluginExecutionException(String.format("Not able to extract AWS region from endpoint '%s'", endpoint));
        }
    }
}

