/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.helpers;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.codepipeline.model.Artifact;
import com.amazonaws.services.codepipeline.model.Job;
import com.amazonaws.services.codepipeline.model.S3ArtifactLocation;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3Helper {
    private static final Logger logger = LoggerFactory.getLogger(S3Helper.class);

    public static Path downloadPackageFromJob(Job job) throws CodePipelinePluginExecutionException {
        Artifact artifact = (Artifact)job.getData().getInputArtifacts().get(0);
        logger.debug(String.format("Working on artifact with name %s and revision %s", artifact.getName(), artifact.getRevision()));
        S3Object sessionObject = S3Helper.getS3Object(artifact, job.getData().getArtifactCredentials());
        logger.debug("S3 object with build artifact " + sessionObject.toString());
        return S3Helper.downloadFile(sessionObject);
    }

    private static AmazonS3Client getS3Client(AWSSessionCredentials sessionCredentials) {
        AmazonS3Client client = null;
        if (sessionCredentials != null) {
            client = new AmazonS3Client((AWSCredentials)sessionCredentials);
        }
        return client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path downloadFile(S3Object sessionObject) throws CodePipelinePluginExecutionException {
        try (S3ObjectInputStream inputStream = sessionObject.getObjectContent();){
            Path filePath = Files.createTempFile(UUID.randomUUID().toString(), ".dar", new FileAttribute[0]);
            Files.copy((InputStream)inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            logger.debug("downloaded S3 file to {}", (Object)filePath);
            Path path = filePath;
            return path;
        }
        catch (IOException e) {
            logger.error("Exception while downloading file from S3", (Throwable)e);
            throw new CodePipelinePluginExecutionException("Unable to download file from S3 bucket");
        }
    }

    private static S3Object getS3Object(Artifact artifact, com.amazonaws.services.codepipeline.model.AWSSessionCredentials awsSessionCredentials) {
        S3ArtifactLocation artifactLocation = artifact.getLocation().getS3Location();
        BasicSessionCredentials basicCredentials = new BasicSessionCredentials(awsSessionCredentials.getAccessKeyId(), awsSessionCredentials.getSecretAccessKey(), awsSessionCredentials.getSessionToken());
        AmazonS3Client client = S3Helper.getS3Client((AWSSessionCredentials)basicCredentials);
        if (client == null) {
            throw new CodePipelinePluginExecutionException("No S3 Object Found!!");
        }
        String bucketName = artifactLocation.getBucketName();
        S3Object sessionObject = client.getObject(bucketName, artifactLocation.getObjectKey());
        return sessionObject;
    }
}

