/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.processor;

import com.amazonaws.services.codepipeline.model.Job;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.codepipeline.actions.Action;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.plugin.codepipeline.helpers.BeansFactory;
import com.xebialabs.deployit.plugin.codepipeline.helpers.ConfigurationItemUtils;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;
import com.xebialabs.deployit.plugin.codepipeline.services.XLDeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobProcessor.class);
    private final CodePipelineJobService jobService;
    private final XLDeployService xlDeployService;

    public JobProcessor(CodePipelineJobService jobService, XLDeployService xlDeployService) {
        this.jobService = jobService;
        this.xlDeployService = xlDeployService;
    }

    public StepExitCode processJob(Job job) {
        try {
            LOGGER.info("Processing job with id {}", (Object)job.getId());
            String environmentId = this.jobService.getJobData(job, "Environment ID");
            String deploymentPackageName = this.jobService.getJobData(job, "Deployment Package Name");
            String deploymentPackageVersion = this.jobService.getJobData(job, "Deployment Package Version");
            this.jobService.acknowledgeJob(job);
            this.validate(job, deploymentPackageName, deploymentPackageVersion);
            String deploymentPackageId = this.getPackageId(job, deploymentPackageName, deploymentPackageVersion);
            Deployment deployment = this.getDeployment(environmentId, deploymentPackageId);
            this.validateDeployment(deployment);
            TaskExecutionState taskExecutionState = this.executeDeploymentTask(job, deployment);
            this.sendJobStatusToCodePipeline(job, taskExecutionState);
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.jobService.sendJobFailureStatus(job, e.getMessage());
            return StepExitCode.FAIL;
        }
    }

    private void sendJobStatusToCodePipeline(Job job, TaskExecutionState taskExecutionState) {
        if (taskExecutionState == TaskExecutionState.EXECUTED) {
            this.jobService.sendJobSuccessStatus(job, "Finished");
        } else {
            this.jobService.sendJobFailureStatus(job, "Deployment task failed with state " + taskExecutionState.name());
        }
    }

    private TaskExecutionState executeDeploymentTask(Job job, Deployment deployment) {
        String taskId = BeansFactory.getPrepareAction(this.jobService, this.xlDeployService, job, deployment).perform();
        TaskExecutionState state = BeansFactory.getExecuteTaskAction(this.xlDeployService, taskId).perform();
        LOGGER.info("Archiving task with id {}", (Object)taskId);
        this.xlDeployService.archiveTask(taskId);
        return state;
    }

    private void validateDeployment(Deployment deployment) {
        BeansFactory.getValidateDeploymentAction(this.xlDeployService, deployment).perform();
    }

    private Deployment getDeployment(String environmentId, String deploymentPackageId) {
        Action deploymentAction = this.getDeploymentAction(deploymentPackageId, environmentId);
        return (Deployment)deploymentAction.perform();
    }

    private Action getDeploymentAction(String deploymentPackageId, String environmentId) {
        return this.xlDeployService.isInitialDeployment(deploymentPackageId, environmentId) ? BeansFactory.getPrepareAction(this.xlDeployService, deploymentPackageId, environmentId) : BeansFactory.getUpdateAction(this.xlDeployService, deploymentPackageId, environmentId);
    }

    private String getPackageId(Job job, String deploymentPackageName, String deploymentPackageVersion) {
        if (this.jobService.hasArtifact(job)) {
            ConfigurationItem ci = this.importConfigurationItem(job, deploymentPackageName, deploymentPackageVersion);
            return ci.getId();
        }
        return ConfigurationItemUtils.getId(deploymentPackageName, deploymentPackageVersion);
    }

    private ConfigurationItem importConfigurationItem(Job job, String deploymentPackageName, String deploymentPackageVersion) {
        return BeansFactory.getImportAction(this.xlDeployService, this.jobService, job, deploymentPackageName, deploymentPackageVersion).perform();
    }

    private void validate(Job job, String deploymentPackageName, String deploymentPackageVersion) {
        if (!this.jobService.hasArtifact(job)) {
            this.validateExistingPackage(deploymentPackageName, deploymentPackageVersion);
        }
    }

    private void validateExistingPackage(String deploymentPackageName, String deploymentPackageVersion) {
        if (deploymentPackageName == null || deploymentPackageVersion == null || deploymentPackageName.isEmpty() || deploymentPackageVersion.isEmpty()) {
            throw new CodePipelinePluginExecutionException(String.format("Deployment Package name and version should be specified", deploymentPackageVersion));
        }
    }
}

