#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import socket
try:
    socket.SOL_TCP # if socket.SOL_TCP does not exist then jython will raise an AttributeError
except AttributeError , ae:
    socket.SOL_TCP = 6 # workaround for missing var in jython import

import docker
import sys
import tempfile
import tarfile, io
import os
import json
import requests.packages.urllib3
requests.packages.urllib3.disable_warnings()

def create_temp_cert_file(contents):
    temp = tempfile.NamedTemporaryFile(delete=False)
    temp.write(contents)
    temp.seek(0)
    return temp

def connect_to_docker(host):
    print "Connecting to Docker host", host['dockerHost'], " "

    base_url = host['dockerHost']
    if base_url.startswith("tcp://"):
        if host['enableTLS']:
            base_url = "https://" + base_url[6:]
        else:
            base_url = "http://" + base_url[6:]

    if host['enableTLS']:
        certpem = create_temp_cert_file(host['certPem'])
        keypem = create_temp_cert_file(host['keyPem'])
        capem = create_temp_cert_file(host['caPem'])

        os.environ['REQUESTS_CA_BUNDLE'] = capem.name

        tls_config = docker.tls.TLSConfig(
                client_cert=(certpem.name, keypem.name),
                verify=capem.name,
                assert_hostname=False
        )
        client = docker.DockerClient(base_url=base_url, tls=tls_config)
    else:
        client = docker.DockerClient(base_url=base_url)

    return client

def print_docker_progress(stream):
    status = ""
    for line in stream:
        for jsonStr in line.split('\r\n'):
            if not jsonStr:
                continue
            jsonObj = json.loads(jsonStr)
            if 'status' in jsonObj:
                if jsonObj['status'] != status:
                    status = jsonObj['status']
                    if 'id' in jsonObj:
                        print "%s: %s" % (jsonObj['id'], status), " "
                    else:
                        print status, " "
            elif 'error' in jsonObj:
                print jsonObj['error'], " "
                sys.exit(1)
            else:
                print line

def check_docker_response(response):
    print response, " "


def copy_artifact_on_docker_container(deployed, artifact_name):

    dkr = connect_to_docker(deployed.container)
    tarbytes = io.BytesIO()
    tar = tarfile.open(fileobj=tarbytes, mode='w')
    tar.add(deployed.file.path, arcname=artifact_name)
    tar.close()

    dkr.api.put_archive(deployed.targetContainer, deployed.targetPath, tarbytes.getvalue())

