/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.docker;

import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="dockerTLSValidator")
@Target(value={ElementType.TYPE})
public @interface DockerTLSValidator {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<BaseContainer> {
        public void validate(BaseContainer value, ValidationContext context) {
            boolean enableTls = Boolean.valueOf(value.getProperty("enableTLS").toString());
            String certPem = (String)value.getProperty("certPem");
            String keyPem = (String)value.getProperty("keyPem");
            String caPem = (String)value.getProperty("caPem");
            if (enableTls && (this.isEmpty(certPem) || this.isEmpty(keyPem) || this.isEmpty(caPem))) {
                context.error("When TLS is enabled, you must provide all certificates.", new Object[]{""});
            }
        }

        private boolean isEmpty(String key) {
            return key == null || key.trim().length() < 1;
        }
    }
}

