import socket
import tempfile
try:
    socket.SOL_TCP # if socket.SOL_TCP does not exist then jython raise AttributeError
except AttributeError , ae:
    socket.SOL_TCP = 6 # workaround for missing var in jython import

import docker
import json
import sys

def create_temp_cert_file(contents):
    temp = tempfile.NamedTemporaryFile(delete=False)
    temp.write(contents)
    temp.seek(0)
    return temp

def connect_to_docker(host):
    # Connect to Docker host
    print "Connecting to Docker host", host['dockerHost'], " "
    if host['enableTLS']:
        certpem = create_temp_cert_file(host['certPem'])
        keypem = create_temp_cert_file(host['keyPem'])
        capem = create_temp_cert_file(host['caPem'])

        tls_config = docker.tls.TLSConfig(
                client_cert=(certpem.name, keypem.name),
                verify=capem.name,
                assert_hostname=False
        )
        client = docker.Client(base_url=host['dockerHost'], tls=tls_config)
    else:
        client = docker.Client(base_url=host['dockerHost'])

    return client

def print_docker_progress(stream):
    status = ""
    for p in stream:
        pp = json.loads(p)
        if 'status' in pp:
            if pp['status'] != status:
                status = pp['status']
                if 'id' in pp:
                    print "%s: %s" % (pp['id'], status), " "
                else:
                    print status, " "
        elif 'error' in pp:
            print pp['error'], " "
            sys.exit(1)
        else:
            print p

def check_docker_response(response):
    print response, " "

def get_derived_container_name(deployed, app):
    return "%s_%s_%s_%s" % (app.environment.name,app.version.application.name, app.version.name, deployed.name)

def get_deployed_name_from_container_name(container_name):
    name_list = container_name.split("_")
    if len(name_list) > 2:
        return name_list[-1]
    else:
        return None

def get_container_name(deployed, deployedApplication):
        return deployed.containerName if deployed.containerName else get_derived_container_name(deployed, deployedApplication)
