#
import sys
import requests


def pretty(d, indent=0):
    keylist = d.keys()
    keylist.sort()
    for key in keylist:
        value = d[key]
        if isinstance(value, dict):
            print "{1}{0}:".format(key, "-" * (indent + 1))
            pretty(value, indent + 1)
        else:
            print "{2}{0}:{1}".format(key, value, "-" * (indent + 1))


from xlddocker import connect_to_docker

print "------------------"
print "Test docker connection on {0}".format(thisCi.name)
print "------------------"
try:
    dkr = connect_to_docker(thisCi)
    print "docker version"
    pretty(dkr.version())
    print "--"
    print "docker info"
    pretty(dkr.info())
except requests.exceptions.RequestException as e:
    print "Request error", str(e)
    sys.exit(1)
except:
    e = sys.exc_info()[0]
    print "Unknown Error", e
    sys.exit(1)
