#
from xlddocker import connect_to_docker
dkr = connect_to_docker(deployed.container)

service_name = deployed.serviceName or deployed.name

print "Retrieving current version of service", service_name
service = dkr.services.get(deployed.serviceId)

print "Requesting update of version", service.version, "of service", deployed.serviceId

restart_policy = None
if deployed.restartPolicyName and deployed.restartPolicyName != 'none':
    restart_policy = {
            'Condition': deployed.restartPolicyName,
            'MaxAttempts': deployed.restartPolicyMaximumRetryCount}

mode = None
if deployed.mode == 'replicated':
    mode = { 'Replicated': { 'Replicas': deployed.replicas } }
elif deployed.mode == 'global':
    mode = { 'Global': { } }

update_config = {
        'Parallelism': deployed.updateParallelism,
        'Delay': deployed.updateDelay,
        'FailureAction': deployed.updateFailureAction }

service.update(
        command=deployed.command,
        container_labels=deployed.containerLabels,
        constraints=deployed.constraints,
        env=deployed.environment,
        image=deployed.image,
        labels=deployed.labels,
        mode=mode,
        name=service_name,
        networks=deployed.networks,
        restart_policy=restart_policy,
        update_config=update_config,
        workdir=deployed.workingDir)

print "Update for", service_name, "has been requested"
