#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from org.xebialabs.googlecloud import GoogleCloudCompute

googleCompute = GoogleCloudCompute(previousDeployed.container.clientEmail, previousDeployed.container.privateKey,
                                   previousDeployed.container.projectId)

instanceName = previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name
zone = previousDeployed.zone

print("Wait for the end of {} {}...".format(instanceName, zone))

if not googleCompute.isOperationDone(previousDeployed.operationSelfLink, zone):
    result = "RETRY"
else:
    print("instance {0} is destroyed".format(instanceName))
