#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#


instance_name = deployed.instanceName if deployed.instanceName else deployed.name

context.addStepWithCheckpoint(steps.jython(
    description="Create instance {0} on {1}".format(instance_name, deployed.container.name),
    script="google/cloud/compute/instance/compute_create.py",
    order=80
), delta)

context.addStep(steps.jython(
    description="Wait for instance {} to be running".format(instance_name),
    script="google/cloud/compute/instance/compute_create_running.py",
    order=81
))

context.addStep(steps.wait(
    description="Wait for the ssh connection is available on {0}".format(instance_name),
    seconds=deployed.waitOnCreate,
    order=82
))
