#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

instance_name = previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name

context.addStepWithCheckpoint(steps.jython(
    description='Destroy instance {} on {}'.format(instance_name, previousDeployed.container.name),
    script="google/cloud/compute/instance/compute_destroy.py",
    order=16
), delta)

context.addStep(steps.jython(
    description="Wait for instance {} to be fully destroy".format(instance_name),
    script="google/cloud/compute/instance/compute_destroy_running.py",
    order=17
))

context.addStep(steps.wait(
    description="Wait for instance {} to be fully destroyed (2)".format(instance_name),
    seconds=previousDeployed.waitOnDestroy,
    order=18
))
