#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
from org.xebialabs.googlecloud import GoogleCloudCompute
print("Check Connection on '%s'" % deployed.container.projectId)
print("Using %s client email" % deployed.container.clientEmail)

googleCompute = GoogleCloudCompute(deployed.container.clientEmail, deployed.container.privateKey,
                                   deployed.container.projectId)

FilePath=deployed.file.path
token = 'Bearer ' + googleCompute.generateToken()

if deployed.UseRestore == True :
    print ('Restoring DialogFlow Agent')
    x = googleCompute.sendPost('https://dialogflow.googleapis.com/v2/projects/' + str(deployed.container.projectId) + '/agent:restore', FilePath, token)
    print ('Restored DialogFlow Agent for '+deployed.container.projectId)
else:
    print ('Importing DialogFlow Agent')
    x = googleCompute.sendPost('https://dialogflow.googleapis.com/v2/projects/' + str(deployed.container.projectId) + '/agent:import', FilePath, token)
    print ('Imported DialogFlow Agent for '+deployed.container.projectId)
