#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

def containers():
    containers = []
    for _delta in deltas.deltas:
        deployed = _delta.deployedOrPrevious
        if (_delta.operation == "CREATE" or _delta.operation == "MODIFY") and (deployed.type == "helm.K8SRelease" or deployed.type == "helm.OpenshiftRelease"):
            if deployed.updateRepositories:
                containers.append(deployed.container)

    return set(containers)


for container in containers():
    context.addStep(steps.os_script(
        description="Update the repositories on {0}".format(container.name),
        order=58,
        script="helm/repository_update",
        freemarker_context={'helmclient': container.container.helmClient},
        target_host=container.container.helmClient.host)
    )
