#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper
from xld.kubernetes.pod.planningScripts.pod_steps_generator import PodsStepsGenerator
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

PodHelper.enrich_app_selectors(deployed)
if PodHelper.get_pod_name(previousDeployed) != PodHelper.get_pod_name(deployed):
    raise RuntimeError('Pod name should not be modified.')

PodsStepsGenerator(context, steps).replace(delta, deployed, previousDeployed)

old_services = ExposedServiceStepsHelper.get_exposed_services(previousDeployed.containers,previousDeployed.labels,
                                                              PodHelper.get_pod_name(previousDeployed))
new_services = ExposedServiceStepsHelper.get_exposed_services(deployed.containers,deployed.labels,
                                                              PodHelper.get_pod_name(deployed))
ExposedServiceStepsHelper(context, steps).add_modify_steps(deployed, previousDeployed, old_services, new_services, delta)
