from kubernetes import client
from kubernetes.client.rest import ApiException
from xld.kubernetes import KubernetesBaseClient
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory


class KubernetesCoreClient(KubernetesBaseClient):
    def __init__(self, container):
        super(KubernetesCoreClient, self).__init__(container)

    def get_core_api(self):
        return client.CoreV1Api(self.internal_api_client)

    def create_pod(self, v1Pod, namespace):
        return self.get_core_api().create_namespaced_pod(namespace=namespace, body=v1Pod)

    def is_pod_running(self, name, container):
        container_helper = ContainerHelperFactory(container).create()
        pod = self.get_core_api().read_namespaced_pod(name=name, namespace=container_helper.get_container_name(container))
        status = pod.status.phase
        print("Status for pod {0} in {1} {2} is {3}".format(pod.metadata.name, container_helper.get_container_label(),
                                                            container_helper.get_container_name(container), status))
        return status == 'Running'

    def is_pod_existing(self, name, namespace):
        try:
            pod = self.get_core_api().read_namespaced_pod(name=name, namespace=namespace)
            if pod:
                return True
        except ApiException as e:
            if e.status == 404:
                return False

    def is_namespace_existing(self, namespace):
        try:
            namespace = self.get_core_api().read_namespace(name=namespace)
            if namespace:
                return True
        except ApiException as e:
            if e.status == 404:
                return False

    def remove_pod(self, name, namespace):
        return self.get_core_api().delete_namespaced_pod(name=name, body={}, namespace=namespace)

    def replace_pod(self, name, v1Pod, namespace):
        return self.get_core_api().replace_namespaced_pod(namespace=namespace, body=v1Pod, name=name)

    def create_namespace(self, v1Namespace):
        return self.get_core_api().create_namespace(v1Namespace)

    def remove_namespace(self, v1Namespace):
        return self.get_core_api().delete_namespace(v1Namespace, body=client.V1DeleteOptions(), grace_period_seconds=0)
