from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.config_map.helper import ConfigMapHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Destroy config map {} from {}".format(ConfigMapHelper().get_config_map_name(previousDeployed),
                                                      container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/config_map/destroy.py",
    order=51
), delta)

context.addStep(steps.jython(
    description="Wait for config map to be destroyed",
    script="xld/kubernetes/config_map/wait_for_destroy.py",
    order=52
))
