import importlib


class K8SResourceFactory(object):
    def __init__(self, deployed):
        self.__deployed = deployed

    def is_supported(self, data):
        return self._is_valid_resource_type(data)


    def get(self, data):
        return self._resolve(data)

    def _resolve(self, data):
        clazz = "{0}ResourceProvider".format(data["kind"])
        factory_module = importlib.import_module("xld.kubernetes.resource.provider")
        provider_clazz = getattr(factory_module, clazz)
        instance = provider_clazz(self.__deployed.container)
        return instance

    def _is_valid_resource_type(self, data):
        return reduce(lambda acc, cur: bool(acc and (cur in ['Pod', 'Service', 'Deployment'])),
                      map(lambda item: item['kind'], data['items'])) \
            if data['kind'] == 'List' else  data['kind'] in ['Pod', 'Service', 'Deployment']
