from kubernetes.client.rest import ApiException
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver
from xld.kubernetes.resource.helper import ResourceHelper

result = "SUCCESS"

resourceDefinition = ResourceHelper(deployed).parse()
resolver = ResourceFactoryResolver(deployed)
resource_factory = resolver.get_factory()
container_helper = ContainerHelperFactory(deployed.container).create()

try:
    if resourceDefinition["kind"] == "List":
        for resource in resourceDefinition["items"]:
            provider = resource_factory.get(resource)  # openshift top level entry
            resources = provider.filter_resources_by_definition(namespace=container_helper.get_container_name(deployed.container),
                                                                resource_definition=resource)
            if resources.kind == "PodList":
                starting_pods = [pod for pod in resources.items if pod.status.phase != "Running"]
                if len(starting_pods) > 0:
                    result = "RETRY"
            elif resources.kind == "RouteList":
                for item in resources.items:
                    for ingress in item.status.ingress:
                        for condition in ingress.conditions:
                            if condition.type == "Admitted" and condition.status == "Unknown":
                                print("Waiting for Route to be activated ...")
                                result = "RETRY"
    else:
        provider = resource_factory.get(resourceDefinition)
        resources = provider.filter_resources_by_definition(namespace=container_helper.get_container_name(deployed.container),
                                                            resource_definition=resourceDefinition)
        if resources.kind == "PodList":
            starting_pods = [pod for pod in resources.items if pod.status.phase != "Running"]
            if len(starting_pods) > 0:
                result = "RETRY"
        elif resources.kind == "RouteList":
            for item in resources.items:
                for ingress in item.status.ingress:
                    for condition in ingress.conditions:
                        if condition.type == "Admitted" and condition.status == "Unknown":
                            print("Waiting for Route to be activated ...")
                            result = "RETRY"

except ApiException as e:
    logger.error("%s" % e)
    print("API error while waiting for resource: %s" % e)
    raise Exception("Resource wait failed.")
