from xld.kubernetes.service.service_helper import ServiceHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(previousDeployed.container).create()
service_name = ServiceHelper().get_service_name(previousDeployed)


context.addStepWithCheckpoint(steps.jython(
    description="Destroy service {0} from {1}".format(service_name, container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/service/remove_service.py",
    order=47
), delta)

# Wait for service delete
context.addStep(steps.jython(
    description="Wait for service {0} to be destroyed completely".format(service_name),
    script="xld/kubernetes/service/wait_for_service_deletion.py",
    order=48
))
