from kubernetes import client


class NamespaceHelper:
    def read_namespace(self, deployed_namespace):
        namespace = client.V1Namespace()
        namespace.metadata = client.V1ObjectMeta(name=NamespaceHelper.get_container_name(deployed_namespace))
        return namespace

    @staticmethod
    def get_container_name(container):
        return container.namespaceName if container.namespaceName else container.name

    @staticmethod
    def get_container_label():
        return "namespace"
