#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver

result = "SUCCESS"

resolver = ResourceFactoryResolver(deployed)
resource_factory = resolver.get_factory()
container_helper = ContainerHelperFactory(deployed.container).create()

with resource_factory.get(data) as provider:
    resources = provider.filter_resources_by_definition(
        namespace=container_helper.get_container_name(deployed.container),
        resource_definition=data)


# hack method to fail process if pods are not at a ready status. result 'FAIL' does not work
def processFail():
    print ("None of the pods were at a ready status after reaching the max number of retries. \n")
    raise Exception(
        "Max number of retries reached. Please verify if readiness probe check is correct or increase the number 'Readiness Probe Retry' in ci properties... \n")
    # fails the deployment here
    exit(1)


def processItem(item):
    if item.status.readyReplicas is None or item.status.readyReplicas < item.spec.replicas:
        if deployed.readinessProbeRetry > 0:
            print(
                "Waiting for DeploymentConfig's {0} to have pods in running state, retries left: {1} (Approx {2} seconds)".format(
                    item.metadata.name, deployed.readinessProbeRetry, deployed.readinessProbeRetry * 5 ))
            deployed.readinessProbeRetry -= 1
            return "RETRY"

        else:
            processFail()
    return "SUCCESS"


if resources.kind == "PodList":
    ready_pods = 0
    starting_pods = [pod for pod in resources.items]

    for pod in starting_pods:
        # ensures there is at least one pod ready
        for c_status in pod.status.containerStatuses:
            if c_status.ready and pod.status.phase == "Running":
                print("Readiness status=%s" % (c_status.ready))
                ready_pods += 1

    if len(starting_pods) != ready_pods and deployed.readinessProbeRetry > 0:
        print("Waiting for pod to be activated ...retries left: %s" % deployed.readinessProbeRetry)
        deployed.readinessProbeRetry -= 1
        result = "RETRY"
    if deployed.readinessProbeRetry <= 0:
        processFail()
elif resources.kind == "RouteList":
    retry_count = 0
    for item in resources.items:
        for ingress in item.status.ingress:
            for condition in ingress.conditions:
                if condition.type == "Admitted" and condition.status == "Unknown" and retry_count < deployed.resourceWaitTime:
                    print("Waiting for Route to be activated ...")
                    result = "RETRY"
                    retry_count = retry_count + 1
elif resources.kind == "DeploymentConfigList":
    for item in resources.items:
        if (deployed.validatePodsCreation):
            result = processItem(item)


elif resources.kind in ["ConfigMapList", "SecretList", "CronJobList"]:
    retry_count = 0
    if not bool(resources.items) and retry_count < deployed.resourceWaitTime:
        result = "RETRY"
        retry_count += 1
elif resources.kind == 'PersistentVolumeClaimList':
    retry_count = 0
    for pv_claim in resources.items:
        if pv_claim.status.phase != 'Bound' and retry_count < deployed.resourceWaitTime:
            print("Waiting for PersistentVolumeClaim to be in Bound phase ...")
            result = "RETRY"
            retry_count = retry_count + 1
