# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'metav1.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1BuildConfigSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'completion_deadline_seconds': 'int',
        'failed_builds_history_limit': 'int',
        'node_selector': 'dict(str, str)',
        'output': 'V1BuildOutput',
        'post_commit': 'V1BuildPostCommitSpec',
        'resources': 'V1ResourceRequirements',
        'revision': 'V1SourceRevision',
        'run_policy': 'str',
        'service_account': 'str',
        'source': 'V1BuildSource',
        'strategy': 'V1BuildStrategy',
        'successful_builds_history_limit': 'int',
        'triggers': 'list[V1BuildTriggerPolicy]'
    }

    attribute_map = {
        'completion_deadline_seconds': 'completionDeadlineSeconds',
        'failed_builds_history_limit': 'failedBuildsHistoryLimit',
        'node_selector': 'nodeSelector',
        'output': 'output',
        'post_commit': 'postCommit',
        'resources': 'resources',
        'revision': 'revision',
        'run_policy': 'runPolicy',
        'service_account': 'serviceAccount',
        'source': 'source',
        'strategy': 'strategy',
        'successful_builds_history_limit': 'successfulBuildsHistoryLimit',
        'triggers': 'triggers'
    }

    def __init__(self, completion_deadline_seconds=None, failed_builds_history_limit=None, node_selector=None, output=None, post_commit=None, resources=None, revision=None, run_policy=None, service_account=None, source=None, strategy=None, successful_builds_history_limit=None, triggers=None):
        """
        V1BuildConfigSpec - a model defined in Swagger
        """

        self._completion_deadline_seconds = None
        self._failed_builds_history_limit = None
        self._node_selector = None
        self._output = None
        self._post_commit = None
        self._resources = None
        self._revision = None
        self._run_policy = None
        self._service_account = None
        self._source = None
        self._strategy = None
        self._successful_builds_history_limit = None
        self._triggers = None
        self.discriminator = None

        if completion_deadline_seconds is not None:
          self.completion_deadline_seconds = completion_deadline_seconds
        if failed_builds_history_limit is not None:
          self.failed_builds_history_limit = failed_builds_history_limit
        self.node_selector = node_selector
        if output is not None:
          self.output = output
        if post_commit is not None:
          self.post_commit = post_commit
        if resources is not None:
          self.resources = resources
        if revision is not None:
          self.revision = revision
        if run_policy is not None:
          self.run_policy = run_policy
        if service_account is not None:
          self.service_account = service_account
        if source is not None:
          self.source = source
        self.strategy = strategy
        if successful_builds_history_limit is not None:
          self.successful_builds_history_limit = successful_builds_history_limit
        self.triggers = triggers

    @property
    def completion_deadline_seconds(self):
        """
        Gets the completion_deadline_seconds of this V1BuildConfigSpec.
        completionDeadlineSeconds is an optional duration in seconds, counted from the time when a build pod gets scheduled in the system, that the build may be active on a node before the system actively tries to terminate the build; value must be positive integer

        :return: The completion_deadline_seconds of this V1BuildConfigSpec.
        :rtype: int
        """
        return self._completion_deadline_seconds

    @completion_deadline_seconds.setter
    def completion_deadline_seconds(self, completion_deadline_seconds):
        """
        Sets the completion_deadline_seconds of this V1BuildConfigSpec.
        completionDeadlineSeconds is an optional duration in seconds, counted from the time when a build pod gets scheduled in the system, that the build may be active on a node before the system actively tries to terminate the build; value must be positive integer

        :param completion_deadline_seconds: The completion_deadline_seconds of this V1BuildConfigSpec.
        :type: int
        """

        self._completion_deadline_seconds = completion_deadline_seconds

    @property
    def failed_builds_history_limit(self):
        """
        Gets the failed_builds_history_limit of this V1BuildConfigSpec.
        failedBuildsHistoryLimit is the number of old failed builds to retain. If not specified, all failed builds are retained.

        :return: The failed_builds_history_limit of this V1BuildConfigSpec.
        :rtype: int
        """
        return self._failed_builds_history_limit

    @failed_builds_history_limit.setter
    def failed_builds_history_limit(self, failed_builds_history_limit):
        """
        Sets the failed_builds_history_limit of this V1BuildConfigSpec.
        failedBuildsHistoryLimit is the number of old failed builds to retain. If not specified, all failed builds are retained.

        :param failed_builds_history_limit: The failed_builds_history_limit of this V1BuildConfigSpec.
        :type: int
        """

        self._failed_builds_history_limit = failed_builds_history_limit

    @property
    def node_selector(self):
        """
        Gets the node_selector of this V1BuildConfigSpec.
        nodeSelector is a selector which must be true for the build pod to fit on a node If nil, it can be overridden by default build nodeselector values for the cluster. If set to an empty map or a map with any values, default build nodeselector values are ignored.

        :return: The node_selector of this V1BuildConfigSpec.
        :rtype: dict(str, str)
        """
        return self._node_selector

    @node_selector.setter
    def node_selector(self, node_selector):
        """
        Sets the node_selector of this V1BuildConfigSpec.
        nodeSelector is a selector which must be true for the build pod to fit on a node If nil, it can be overridden by default build nodeselector values for the cluster. If set to an empty map or a map with any values, default build nodeselector values are ignored.

        :param node_selector: The node_selector of this V1BuildConfigSpec.
        :type: dict(str, str)
        """

        self._node_selector = node_selector

    @property
    def output(self):
        """
        Gets the output of this V1BuildConfigSpec.
        output describes the Docker image the Strategy should produce.

        :return: The output of this V1BuildConfigSpec.
        :rtype: V1BuildOutput
        """
        return self._output

    @output.setter
    def output(self, output):
        """
        Sets the output of this V1BuildConfigSpec.
        output describes the Docker image the Strategy should produce.

        :param output: The output of this V1BuildConfigSpec.
        :type: V1BuildOutput
        """

        self._output = output

    @property
    def post_commit(self):
        """
        Gets the post_commit of this V1BuildConfigSpec.
        postCommit is a build hook executed after the build output image is committed, before it is pushed to a registry.

        :return: The post_commit of this V1BuildConfigSpec.
        :rtype: V1BuildPostCommitSpec
        """
        return self._post_commit

    @post_commit.setter
    def post_commit(self, post_commit):
        """
        Sets the post_commit of this V1BuildConfigSpec.
        postCommit is a build hook executed after the build output image is committed, before it is pushed to a registry.

        :param post_commit: The post_commit of this V1BuildConfigSpec.
        :type: V1BuildPostCommitSpec
        """

        self._post_commit = post_commit

    @property
    def resources(self):
        """
        Gets the resources of this V1BuildConfigSpec.
        resources computes resource requirements to execute the build.

        :return: The resources of this V1BuildConfigSpec.
        :rtype: V1ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this V1BuildConfigSpec.
        resources computes resource requirements to execute the build.

        :param resources: The resources of this V1BuildConfigSpec.
        :type: V1ResourceRequirements
        """

        self._resources = resources

    @property
    def revision(self):
        """
        Gets the revision of this V1BuildConfigSpec.
        revision is the information from the source for a specific repo snapshot. This is optional.

        :return: The revision of this V1BuildConfigSpec.
        :rtype: V1SourceRevision
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """
        Sets the revision of this V1BuildConfigSpec.
        revision is the information from the source for a specific repo snapshot. This is optional.

        :param revision: The revision of this V1BuildConfigSpec.
        :type: V1SourceRevision
        """

        self._revision = revision

    @property
    def run_policy(self):
        """
        Gets the run_policy of this V1BuildConfigSpec.
        RunPolicy describes how the new build created from this build configuration will be scheduled for execution. This is optional, if not specified we default to \"Serial\".

        :return: The run_policy of this V1BuildConfigSpec.
        :rtype: str
        """
        return self._run_policy

    @run_policy.setter
    def run_policy(self, run_policy):
        """
        Sets the run_policy of this V1BuildConfigSpec.
        RunPolicy describes how the new build created from this build configuration will be scheduled for execution. This is optional, if not specified we default to \"Serial\".

        :param run_policy: The run_policy of this V1BuildConfigSpec.
        :type: str
        """

        self._run_policy = run_policy

    @property
    def service_account(self):
        """
        Gets the service_account of this V1BuildConfigSpec.
        serviceAccount is the name of the ServiceAccount to use to run the pod created by this build. The pod will be allowed to use secrets referenced by the ServiceAccount

        :return: The service_account of this V1BuildConfigSpec.
        :rtype: str
        """
        return self._service_account

    @service_account.setter
    def service_account(self, service_account):
        """
        Sets the service_account of this V1BuildConfigSpec.
        serviceAccount is the name of the ServiceAccount to use to run the pod created by this build. The pod will be allowed to use secrets referenced by the ServiceAccount

        :param service_account: The service_account of this V1BuildConfigSpec.
        :type: str
        """

        self._service_account = service_account

    @property
    def source(self):
        """
        Gets the source of this V1BuildConfigSpec.
        source describes the SCM in use.

        :return: The source of this V1BuildConfigSpec.
        :rtype: V1BuildSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this V1BuildConfigSpec.
        source describes the SCM in use.

        :param source: The source of this V1BuildConfigSpec.
        :type: V1BuildSource
        """

        self._source = source

    @property
    def strategy(self):
        """
        Gets the strategy of this V1BuildConfigSpec.
        strategy defines how to perform a build.

        :return: The strategy of this V1BuildConfigSpec.
        :rtype: V1BuildStrategy
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """
        Sets the strategy of this V1BuildConfigSpec.
        strategy defines how to perform a build.

        :param strategy: The strategy of this V1BuildConfigSpec.
        :type: V1BuildStrategy
        """
        if strategy is None:
            raise ValueError("Invalid value for `strategy`, must not be `None`")

        self._strategy = strategy

    @property
    def successful_builds_history_limit(self):
        """
        Gets the successful_builds_history_limit of this V1BuildConfigSpec.
        successfulBuildsHistoryLimit is the number of old successful builds to retain. If not specified, all successful builds are retained.

        :return: The successful_builds_history_limit of this V1BuildConfigSpec.
        :rtype: int
        """
        return self._successful_builds_history_limit

    @successful_builds_history_limit.setter
    def successful_builds_history_limit(self, successful_builds_history_limit):
        """
        Sets the successful_builds_history_limit of this V1BuildConfigSpec.
        successfulBuildsHistoryLimit is the number of old successful builds to retain. If not specified, all successful builds are retained.

        :param successful_builds_history_limit: The successful_builds_history_limit of this V1BuildConfigSpec.
        :type: int
        """

        self._successful_builds_history_limit = successful_builds_history_limit

    @property
    def triggers(self):
        """
        Gets the triggers of this V1BuildConfigSpec.
        triggers determine how new Builds can be launched from a BuildConfig. If no triggers are defined, a new build can only occur as a result of an explicit client build creation.

        :return: The triggers of this V1BuildConfigSpec.
        :rtype: list[V1BuildTriggerPolicy]
        """
        return self._triggers

    @triggers.setter
    def triggers(self, triggers):
        """
        Sets the triggers of this V1BuildConfigSpec.
        triggers determine how new Builds can be launched from a BuildConfig. If no triggers are defined, a new build can only occur as a result of an explicit client build creation.

        :param triggers: The triggers of this V1BuildConfigSpec.
        :type: list[V1BuildTriggerPolicy]
        """
        if triggers is None:
            raise ValueError("Invalid value for `triggers`, must not be `None`")

        self._triggers = triggers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1BuildConfigSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
