from kubernetes.client.rest import ApiException
from xld.openshift.connector import OpenShiftConnector
from xld.kubernetes.commons.common_utils import CommonUtils

kind="ProjectRequest"
api_version="project.openshift.io/v1"

body={
    "kind": kind,
    "apiVersion": api_version,
    "metadata": {
        "name": deployed.projectName
    },
    "spec": {
        "description": deployed.description,
        "displayName": deployed.projectDisplayName
    }
}

with OpenShiftConnector(deployed.container) as connector:
    try:
        print("Creating project: %s" % deployed.projectName)
        CommonUtils.print_request_dump(deployed.container, body, kind,
                                       api_version)
        project_request_response = connector.oapi.resources.get(api_version=api_version, kind=kind).create(body=body)
        CommonUtils.print_response_dump(deployed.container, project_request_response)

    except ApiException as e:
        logger.error("%s" % e)
        print("API error while creating project: %s" % e)
        raise Exception("Project creation failed.")
