from xld.openshift.connector import OpenShiftConnector
from org.apache.commons.io import IOUtils
from kubernetes.client.rest import ApiException

connector = OpenShiftConnector(deployed.container.container)  # openshift top level entry

input_stream = deployed.file.getInputStream()

try:
    resourceIS = IOUtils.toString(input_stream, "UTF-8")
finally:
    IOUtils.closeQuietly(input_stream)

resourceDefinition = connector.parse_resource_definition(resourceIS)

try:
    if resourceDefinition["kind"] == "List":
        for resource in resourceDefinition["items"]:
            print("Updating resource %s, kind %s" % (resource["metadata"]["name"], resource["kind"]))
            multi_connector = OpenShiftConnector(deployed.container.container) # openshift top level entry
            multi_connector.modify_resource_from_object(namespace=deployed.container.projectName , resource_object=resource)
    else:
        print("Updating resource %s, kind %s" % (resourceDefinition["metadata"]["name"], resourceDefinition["kind"]))
        connector.modify_resource_from_object(namespace=deployed.container.projectName , resource_object=resourceDefinition)

except ApiException as e:
    logger.error("%s" % e)
    print("API error while updating resource: %s" % e)
    raise Exception("Resource modification failed.")